/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.support;

import java.io.IOException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.index.fielddata.IndexFieldData;
import org.codelibs.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.codelibs.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.codelibs.elasticsearch.index.mapper.DateFieldMapper;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.joda.time.DateTimeZone;

public enum ValueType implements Writeable
{
    STRING(1, "string", "string", ValuesSourceType.BYTES, IndexFieldData.class, DocValueFormat.RAW),
    LONG(2, "byte|short|integer|long", "long", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.RAW){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    DOUBLE(3, "float|double", "double", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.RAW){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }
    }
    ,
    NUMBER(4, "number", "number", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.RAW){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    DATE(5, "date", "date", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, (DocValueFormat)new DocValueFormat.DateTime(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, DateTimeZone.UTC)){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    IP(6, "ip", "ip", ValuesSourceType.BYTES, IndexFieldData.class, DocValueFormat.IP),
    NUMERIC(7, "numeric", "numeric", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.RAW){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    GEOPOINT(8, "geo_point", "geo_point", ValuesSourceType.GEOPOINT, IndexGeoPointFieldData.class, DocValueFormat.GEOHASH){

        @Override
        public boolean isGeoPoint() {
            return true;
        }
    }
    ,
    BOOLEAN(9, "boolean", "boolean", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.BOOLEAN){

        @Override
        public boolean isNumeric() {
            return super.isNumeric();
        }
    };

    final String description;
    final ValuesSourceType valuesSourceType;
    final Class<? extends IndexFieldData> fieldDataType;
    final DocValueFormat defaultFormat;
    private final byte id;
    private String preferredName;

    private ValueType(byte id, String description, String preferredName, ValuesSourceType valuesSourceType, Class<? extends IndexFieldData> fieldDataType, DocValueFormat defaultFormat) {
        this.id = id;
        this.description = description;
        this.preferredName = preferredName;
        this.valuesSourceType = valuesSourceType;
        this.fieldDataType = fieldDataType;
        this.defaultFormat = defaultFormat;
    }

    public String description() {
        return this.description;
    }

    public String getPreferredName() {
        return this.preferredName;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public boolean compatibleWith(IndexFieldData fieldData) {
        return this.fieldDataType.isInstance(fieldData);
    }

    public boolean isA(ValueType valueType) {
        return valueType.valuesSourceType == this.valuesSourceType && valueType.fieldDataType.isAssignableFrom(this.fieldDataType);
    }

    public boolean isNotA(ValueType valueType) {
        return !this.isA(valueType);
    }

    public DocValueFormat defaultFormat() {
        return this.defaultFormat;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public boolean isGeoPoint() {
        return false;
    }

    public static ValueType resolveForScript(String type) {
        switch (type) {
            case "string": {
                return STRING;
            }
            case "double": 
            case "float": {
                return DOUBLE;
            }
            case "long": 
            case "integer": 
            case "short": 
            case "byte": {
                return LONG;
            }
            case "date": {
                return DATE;
            }
            case "ip": {
                return IP;
            }
            case "boolean": {
                return BOOLEAN;
            }
        }
        return null;
    }

    public String toString() {
        return this.description;
    }

    public static ValueType readFromStream(StreamInput in) throws IOException {
        byte id = in.readByte();
        for (ValueType valueType : ValueType.values()) {
            if (id != valueType.id) continue;
            return valueType;
        }
        throw new IOException("No valueType found for id [" + id + "]");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }
}

