/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.pipeline.cumulativesum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.codelibs.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.codelibs.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.codelibs.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class CumulativeSumPipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;

    public CumulativeSumPipelineAggregator(String name, String[] bucketsPaths, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
    }

    public CumulativeSumPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.formatter = in.readNamedWriteable(DocValueFormat.class);
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.formatter);
    }

    @Override
    public String getWriteableName() {
        return "cumulative_sum";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        MultiBucketsAggregation histo = (MultiBucketsAggregation)((Object)aggregation);
        List<? extends MultiBucketsAggregation.Bucket> buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)((Object)histo);
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>();
        double sum = 0.0;
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, bucket, this.bucketsPaths()[0], BucketHelpers.GapPolicy.INSERT_ZEROS);
            List<InternalAggregation> aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
            aggs.add(new InternalSimpleValue(this.name(), sum += thisBucketValue.doubleValue(), this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
            MultiBucketsAggregation.Bucket newBucket = factory.createBucket(factory.getKey(bucket), bucket.getDocCount(), new InternalAggregations(aggs));
            newBuckets.add(newBucket);
        }
        return factory.createAggregation(newBuckets);
    }
}

