/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.pipeline.bucketselector;

import java.io.IOException;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.script.Script;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class BucketSelectorPipelineAggregator
extends PipelineAggregator {
    private BucketHelpers.GapPolicy gapPolicy;
    private Script script;
    private Map<String, String> bucketsPathsMap;

    public BucketSelectorPipelineAggregator(String name, Map<String, String> bucketsPathsMap, Script script, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, bucketsPathsMap.values().toArray(new String[bucketsPathsMap.size()]), metadata);
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
        this.gapPolicy = gapPolicy;
    }

    public BucketSelectorPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.bucketsPathsMap = (Map)in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        this.gapPolicy.writeTo(out);
        out.writeGenericValue(this.bucketsPathsMap);
    }

    @Override
    public String getWriteableName() {
        return "bucket_selector";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }
}

