/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.InternalExtendedStatsBucket;

public class ExtendedStatsBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private final double sigma;
    private double sum = 0.0;
    private long count = 0L;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double sumOfSqrs = 1.0;

    protected ExtendedStatsBucketPipelineAggregator(String name, String[] bucketsPaths, double sigma, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
        this.sigma = sigma;
    }

    public ExtendedStatsBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.sigma = in.readDouble();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sigma);
    }

    @Override
    public String getWriteableName() {
        return "extended_stats_bucket";
    }

    @Override
    protected void preCollection() {
        this.sum = 0.0;
        this.count = 0L;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.sumOfSqrs = 0.0;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.sum += bucketValue.doubleValue();
        this.min = Math.min(this.min, bucketValue);
        this.max = Math.max(this.max, bucketValue);
        ++this.count;
        this.sumOfSqrs += bucketValue * bucketValue;
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        return new InternalExtendedStatsBucket(this.name(), this.count, this.sum, this.min, this.max, this.sumOfSqrs, this.sigma, this.format, pipelineAggregators, metadata);
    }
}

