/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.InternalPercentilesBucket;

public class PercentilesBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    public final ParseField PERCENTS_FIELD = new ParseField("percents", new String[0]);
    private final double[] percents;
    private List<Double> data;

    protected PercentilesBucketPipelineAggregator(String name, double[] percents, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
        this.percents = percents;
    }

    public PercentilesBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.percents = in.readDoubleArray();
    }

    @Override
    public void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.percents);
    }

    @Override
    public String getWriteableName() {
        return "percentiles_bucket";
    }

    @Override
    protected void preCollection() {
        this.data = new ArrayList<Double>(1024);
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.data.add(bucketValue);
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        Collections.sort(this.data);
        double[] percentiles = new double[this.percents.length];
        if (this.data.size() == 0) {
            for (int i = 0; i < this.percents.length; ++i) {
                percentiles[i] = Double.NaN;
            }
        } else {
            for (int i = 0; i < this.percents.length; ++i) {
                int index = (int)Math.round(this.percents[i] / 100.0 * (double)(this.data.size() - 1));
                percentiles[i] = this.data.get(index);
            }
        }
        return new InternalPercentilesBucket(this.name(), this.percents, percentiles, this.format, pipelineAggregators, metadata);
    }
}

