/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.XContentLocation;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.search.aggregations.AggregationExecutionException;
import org.codelibs.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.codelibs.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.codelibs.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.support.AggregationPath;

public class BucketHelpers {
    public static Double resolveBucketValue(MultiBucketsAggregation agg, MultiBucketsAggregation.Bucket bucket, String aggPath, GapPolicy gapPolicy) {
        List<String> aggPathsList = AggregationPath.parse(aggPath).getPathElementsAsStringList();
        return BucketHelpers.resolveBucketValue(agg, bucket, aggPathsList, gapPolicy);
    }

    public static Double resolveBucketValue(MultiBucketsAggregation agg, MultiBucketsAggregation.Bucket bucket, List<String> aggPathAsList, GapPolicy gapPolicy) {
        try {
            boolean isDocCountProperty;
            double value;
            Object propertyValue = bucket.getProperty(agg.getName(), aggPathAsList);
            if (propertyValue == null) {
                throw new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference either a number value or a single value numeric metric aggregation");
            }
            if (propertyValue instanceof Number) {
                value = ((Number)propertyValue).doubleValue();
            } else if (propertyValue instanceof InternalNumericMetricsAggregation.SingleValue) {
                value = ((InternalNumericMetricsAggregation.SingleValue)propertyValue).value();
            } else {
                throw new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference either a number value or a single value numeric metric aggregation, got: " + propertyValue.getClass().getCanonicalName());
            }
            boolean bl = isDocCountProperty = aggPathAsList.size() == 1 && "_count".equals(aggPathAsList.get(0));
            if (Double.isInfinite(value) || Double.isNaN(value) || bucket.getDocCount() == 0L && !isDocCountProperty) {
                switch (gapPolicy) {
                    case INSERT_ZEROS: {
                        return 0.0;
                    }
                }
                return Double.NaN;
            }
            return value;
        }
        catch (InvalidAggregationPathException e) {
            return null;
        }
    }

    public static enum GapPolicy {
        INSERT_ZEROS(0, "insert_zeros"),
        SKIP(1, "skip");

        private final byte id;
        private final ParseField parseField;

        public static GapPolicy parse(QueryParseContext context, String text, XContentLocation tokenLocation) {
            GapPolicy result = null;
            for (GapPolicy policy : GapPolicy.values()) {
                if (!policy.parseField.match(text)) continue;
                if (result == null) {
                    result = policy;
                    continue;
                }
                throw new IllegalStateException("Text can be parsed to 2 different gap policies: text=[" + text + "], " + "policies=" + Arrays.asList(result, policy));
            }
            if (result == null) {
                ArrayList<String> validNames = new ArrayList<String>();
                for (GapPolicy policy : GapPolicy.values()) {
                    validNames.add(policy.getName());
                }
                throw new ParsingException(tokenLocation, "Invalid gap policy: [" + text + "], accepted values: " + validNames, new Object[0]);
            }
            return result;
        }

        private GapPolicy(byte id, String name) {
            this.id = id;
            this.parseField = new ParseField(name, new String[0]);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }

        public static GapPolicy readFrom(StreamInput in) throws IOException {
            byte id = in.readByte();
            for (GapPolicy gapPolicy : GapPolicy.values()) {
                if (id != gapPolicy.id) continue;
                return gapPolicy;
            }
            throw new IllegalStateException("Unknown GapPolicy with id [" + id + "]");
        }

        public String getName() {
            return this.parseField.getPreferredName();
        }
    }
}

