/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.valuecount;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalValueCount
extends InternalNumericMetricsAggregation.SingleValue
implements ValueCount {
    private final long value;

    public InternalValueCount(String name, long value, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.value = value;
    }

    public InternalValueCount(StreamInput in) throws IOException {
        super(in);
        this.value = in.readVLong();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.value);
    }

    @Override
    public String getWriteableName() {
        return "value_count";
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long valueCount = 0L;
        for (InternalAggregation aggregation : aggregations) {
            valueCount += ((InternalValueCount)aggregation).value;
        }
        return new InternalValueCount(this.name, valueCount, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("value", this.value);
        return builder;
    }

    public String toString() {
        return "count[" + this.value + "]";
    }
}

