/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.codelibs.elasticsearch.common.lease.Releasable;
import org.codelibs.elasticsearch.common.lease.Releasables;
import org.codelibs.elasticsearch.common.util.LongObjectPagedHashMap;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.codelibs.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.codelibs.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class TopHitsAggregator
extends MetricsAggregator {
    final LongObjectPagedHashMap<TopDocsAndLeafCollector> topDocsCollectors;

    public TopHitsAggregator(String name, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public boolean needsScores() {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void setScorer(Scorer scorer) throws IOException {
                for (LongObjectPagedHashMap.Cursor<TopDocsAndLeafCollector> cursor : TopHitsAggregator.this.topDocsCollectors) {
                    ((TopDocsAndLeafCollector)cursor.value).leafCollector.setScorer(scorer);
                }
                super.setScorer(scorer);
            }

            @Override
            public void collect(int docId, long bucket) throws IOException {
                throw new UnsupportedOperationException("querybuilders does not support this operation.");
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public InternalTopHits buildEmptyAggregation() {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected void doClose() {
        Releasables.close(new Releasable[]{this.topDocsCollectors});
    }

    private static class TopDocsAndLeafCollector {
        LeafCollector leafCollector;

        private TopDocsAndLeafCollector() {
        }
    }
}

