/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.TopDocs;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.lucene.Lucene;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalTopHits
extends InternalMetricsAggregation
implements TopHits {
    private int from;
    private int size;
    private TopDocs topDocs;

    public InternalTopHits(String name, int from, int size, TopDocs topDocs, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.from = from;
        this.size = size;
        this.topDocs = topDocs;
    }

    public InternalTopHits(StreamInput in) throws IOException {
        super(in);
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        assert (this.topDocs != null);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs);
    }

    @Override
    public String getWriteableName() {
        return "top_hits";
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }
}

