/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.script.Script;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetric;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalScriptedMetric
extends InternalMetricsAggregation
implements ScriptedMetric {
    private final Script reduceScript;
    private final Object aggregation;

    public InternalScriptedMetric(String name, Object aggregation, Script reduceScript, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.aggregation = aggregation;
        this.reduceScript = reduceScript;
    }

    public InternalScriptedMetric(StreamInput in) throws IOException {
        super(in);
        this.reduceScript = in.readOptionalWriteable(Script::new);
        this.aggregation = in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.reduceScript);
        out.writeGenericValue(this.aggregation);
    }

    @Override
    public String getWriteableName() {
        return "scripted_metric";
    }

    @Override
    public Object aggregation() {
        return this.aggregation;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.aggregation;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("value", this.aggregation);
    }
}

