/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.tdigest.AbstractInternalTDigestPercentiles;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalTDigestPercentiles
extends AbstractInternalTDigestPercentiles
implements Percentiles {
    public static final String NAME = "tdigest_percentiles";

    public InternalTDigestPercentiles(String name, double[] percents, TDigestState state, boolean keyed, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, percents, state, keyed, formatter, pipelineAggregators, metaData);
    }

    public InternalTDigestPercentiles(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percentile(double percent) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public String percentileAsString(double percent) {
        return this.valueAsString(String.valueOf(percent));
    }

    @Override
    public double value(double key) {
        return this.percentile(key);
    }

    @Override
    protected AbstractInternalTDigestPercentiles createReduced(String name, double[] keys, TDigestState merged, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        return new InternalTDigestPercentiles(name, keys, merged, keyed, this.format, pipelineAggregators, metaData);
    }

    public static class Iter
    implements Iterator<Percentile> {
        private final double[] percents;
        private int i;

        public Iter(double[] percents, TDigestState state) {
            this.percents = percents;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        @Override
        public Percentile next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

