/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentile;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.PercentileRanks;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.tdigest.AbstractInternalTDigestPercentiles;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalTDigestPercentileRanks
extends AbstractInternalTDigestPercentiles
implements PercentileRanks {
    public static final String NAME = "tdigest_percentile_ranks";

    public InternalTDigestPercentileRanks(String name, double[] cdfValues, TDigestState state, boolean keyed, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, cdfValues, state, keyed, formatter, pipelineAggregators, metaData);
    }

    public InternalTDigestPercentileRanks(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percent(double value) {
        return InternalTDigestPercentileRanks.percentileRank(this.state, value);
    }

    @Override
    public String percentAsString(double value) {
        return this.valueAsString(String.valueOf(value));
    }

    @Override
    public double value(double key) {
        return this.percent(key);
    }

    @Override
    protected AbstractInternalTDigestPercentiles createReduced(String name, double[] keys, TDigestState merged, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        return new InternalTDigestPercentileRanks(name, keys, merged, keyed, this.format, pipelineAggregators, metaData);
    }

    static double percentileRank(TDigestState state, double value) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public static class Iter
    implements Iterator<Percentile> {
        private final double[] values;
        private final TDigestState state;
        private int i;

        public Iter(double[] values, TDigestState state) {
            this.values = values;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.values.length;
        }

        @Override
        public Percentile next() {
            InternalPercentile next = new InternalPercentile(InternalTDigestPercentileRanks.percentileRank(this.state, this.values[this.i]), this.values[this.i]);
            ++this.i;
            return next;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

