/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

abstract class AbstractInternalTDigestPercentiles
extends InternalNumericMetricsAggregation.MultiValue {
    protected final double[] keys;
    protected final TDigestState state;
    private final boolean keyed;

    public AbstractInternalTDigestPercentiles(String name, double[] keys, TDigestState state, boolean keyed, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.keys = keys;
        this.state = state;
        this.keyed = keyed;
        this.format = formatter;
    }

    protected AbstractInternalTDigestPercentiles(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keys = in.readDoubleArray();
        this.state = TDigestState.read(in);
        this.keyed = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDoubleArray(this.keys);
        TDigestState.write(this.state, out);
        out.writeBoolean(this.keyed);
    }

    @Override
    public double value(String name) {
        return this.value(Double.parseDouble(name));
    }

    public abstract double value(double var1);

    public long getEstimatedMemoryFootprint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractInternalTDigestPercentiles doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException();
    }

    protected abstract AbstractInternalTDigestPercentiles createReduced(String var1, double[] var2, TDigestState var3, boolean var4, List<PipelineAggregator> var5, Map<String, Object> var6);

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject("values");
            for (double key2 : this.keys) {
                String key = String.valueOf(key2);
                double value = this.value(key2);
                builder.field(key, value);
                if (this.format == DocValueFormat.RAW) continue;
                builder.field(key + "_as_string", this.format.format(value));
            }
            builder.endObject();
        } else {
            builder.startArray("values");
            for (double key : this.keys) {
                double value = this.value(key);
                builder.startObject();
                builder.field("key", key);
                builder.field("value", value);
                if (this.format != DocValueFormat.RAW) {
                    builder.field("value_as_string", this.format.format(value));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }
}

