/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.percentiles.hdr;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

abstract class AbstractInternalHDRPercentiles
extends InternalNumericMetricsAggregation.MultiValue {
    protected final double[] keys;
    private final boolean keyed;

    public AbstractInternalHDRPercentiles(String name, double[] keys, boolean keyed, DocValueFormat format, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    protected AbstractInternalHDRPercentiles(StreamInput in) throws IOException {
        super(in);
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public double value(String name) {
        return this.value(Double.parseDouble(name));
    }

    public abstract double value(double var1);

    public long getEstimatedMemoryFootprint() {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public AbstractInternalHDRPercentiles doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    protected abstract AbstractInternalHDRPercentiles createReduced(String var1, double[] var2, boolean var3, List<PipelineAggregator> var4, Map<String, Object> var5);

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject("values");
            for (double key2 : this.keys) {
                String key = String.valueOf(key2);
                double value = this.value(key2);
                builder.field(key, value);
                if (this.format == DocValueFormat.RAW) continue;
                builder.field(key + "_as_string", this.format.format(value));
            }
            builder.endObject();
        } else {
            builder.startArray("values");
            for (double key : this.keys) {
                double value = this.value(key);
                builder.startObject();
                builder.field("key", key);
                builder.field("value", value);
                if (this.format != DocValueFormat.RAW) {
                    builder.field("value_as_string", this.format.format(value));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }
}

