/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.max;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.max.Max;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalMax
extends InternalNumericMetricsAggregation.SingleValue
implements Max {
    private final double max;

    public InternalMax(String name, double max, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.format = formatter;
        this.max = max;
    }

    public InternalMax(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.max = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.max);
    }

    @Override
    public String getWriteableName() {
        return "max";
    }

    @Override
    public double value() {
        return this.max;
    }

    @Override
    public double getValue() {
        return this.max;
    }

    @Override
    public InternalMax doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double max = Double.NEGATIVE_INFINITY;
        for (InternalAggregation aggregation : aggregations) {
            max = Math.max(max, ((InternalMax)aggregation).max);
        }
        return new InternalMax(this.name, max, this.format, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.max);
        builder.field("value", hasValue ? Double.valueOf(this.max) : null);
        if (hasValue && this.format != DocValueFormat.RAW) {
            builder.field("value_as_string", this.format.format(this.max));
        }
        return builder;
    }
}

