/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.geobounds;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.geo.GeoPoint;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.codelibs.elasticsearch.search.aggregations.metrics.geobounds.GeoBounds;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalGeoBounds
extends InternalMetricsAggregation
implements GeoBounds {
    private final double top;
    private final double bottom;
    private final double posLeft;
    private final double posRight;
    private final double negLeft;
    private final double negRight;
    private final boolean wrapLongitude;

    InternalGeoBounds(String name, double top, double bottom, double posLeft, double posRight, double negLeft, double negRight, boolean wrapLongitude, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.top = top;
        this.bottom = bottom;
        this.posLeft = posLeft;
        this.posRight = posRight;
        this.negLeft = negLeft;
        this.negRight = negRight;
        this.wrapLongitude = wrapLongitude;
    }

    public InternalGeoBounds(StreamInput in) throws IOException {
        super(in);
        this.top = in.readDouble();
        this.bottom = in.readDouble();
        this.posLeft = in.readDouble();
        this.posRight = in.readDouble();
        this.negLeft = in.readDouble();
        this.negRight = in.readDouble();
        this.wrapLongitude = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.top);
        out.writeDouble(this.bottom);
        out.writeDouble(this.posLeft);
        out.writeDouble(this.posRight);
        out.writeDouble(this.negLeft);
        out.writeDouble(this.negRight);
        out.writeBoolean(this.wrapLongitude);
    }

    @Override
    public String getWriteableName() {
        return "geo_bounds";
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double top = Double.NEGATIVE_INFINITY;
        double bottom = Double.POSITIVE_INFINITY;
        double posLeft = Double.POSITIVE_INFINITY;
        double posRight = Double.NEGATIVE_INFINITY;
        double negLeft = Double.POSITIVE_INFINITY;
        double negRight = Double.NEGATIVE_INFINITY;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoBounds bounds = (InternalGeoBounds)aggregation;
            if (bounds.top > top) {
                top = bounds.top;
            }
            if (bounds.bottom < bottom) {
                bottom = bounds.bottom;
            }
            if (bounds.posLeft < posLeft) {
                posLeft = bounds.posLeft;
            }
            if (bounds.posRight > posRight) {
                posRight = bounds.posRight;
            }
            if (bounds.negLeft < negLeft) {
                negLeft = bounds.negLeft;
            }
            if (!(bounds.negRight > negRight)) continue;
            negRight = bounds.negRight;
        }
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String bBoxSide;
            BoundingBox boundingBox = this.resolveBoundingBox();
            switch (bBoxSide = path.get(0)) {
                case "top": {
                    return boundingBox.topLeft.lat();
                }
                case "left": {
                    return boundingBox.topLeft.lon();
                }
                case "bottom": {
                    return boundingBox.bottomRight.lat();
                }
                case "right": {
                    return boundingBox.bottomRight.lon();
                }
            }
            throw new IllegalArgumentException("Found unknown path element [" + bBoxSide + "] in [" + this.getName() + "]");
        }
        if (path.size() == 2) {
            String latLonString;
            String cornerString;
            BoundingBox boundingBox = this.resolveBoundingBox();
            GeoPoint cornerPoint = null;
            switch (cornerString = path.get(0)) {
                case "top_left": {
                    cornerPoint = boundingBox.topLeft;
                    break;
                }
                case "bottom_right": {
                    cornerPoint = boundingBox.bottomRight;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Found unknown path element [" + cornerString + "] in [" + this.getName() + "]");
                }
            }
            switch (latLonString = path.get(1)) {
                case "lat": {
                    return cornerPoint.lat();
                }
                case "lon": {
                    return cornerPoint.lon();
                }
            }
            throw new IllegalArgumentException("Found unknown path element [" + latLonString + "] in [" + this.getName() + "]");
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        GeoPoint topLeft = this.topLeft();
        GeoPoint bottomRight = this.bottomRight();
        if (topLeft != null) {
            builder.startObject("bounds");
            builder.startObject("top_left");
            builder.field("lat", topLeft.lat());
            builder.field("lon", topLeft.lon());
            builder.endObject();
            builder.startObject("bottom_right");
            builder.field("lat", bottomRight.lat());
            builder.field("lon", bottomRight.lon());
            builder.endObject();
            builder.endObject();
        }
        return builder;
    }

    private BoundingBox resolveBoundingBox() {
        if (Double.isInfinite(this.top)) {
            return null;
        }
        if (Double.isInfinite(this.posLeft)) {
            return new BoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.negRight));
        }
        if (Double.isInfinite(this.negLeft)) {
            return new BoundingBox(new GeoPoint(this.top, this.posLeft), new GeoPoint(this.bottom, this.posRight));
        }
        if (this.wrapLongitude) {
            double unwrappedWidth = this.posRight - this.negLeft;
            double wrappedWidth = 180.0 - this.posLeft - (-180.0 - this.negRight);
            if (unwrappedWidth <= wrappedWidth) {
                return new BoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.posRight));
            }
            return new BoundingBox(new GeoPoint(this.top, this.posLeft), new GeoPoint(this.bottom, this.negRight));
        }
        return new BoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.posRight));
    }

    @Override
    public GeoPoint topLeft() {
        BoundingBox boundingBox = this.resolveBoundingBox();
        if (boundingBox == null) {
            return null;
        }
        return boundingBox.topLeft();
    }

    @Override
    public GeoPoint bottomRight() {
        BoundingBox boundingBox = this.resolveBoundingBox();
        if (boundingBox == null) {
            return null;
        }
        return boundingBox.bottomRight();
    }

    private static class BoundingBox {
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        public BoundingBox(GeoPoint topLeft, GeoPoint bottomRight) {
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        public GeoPoint topLeft() {
            return this.topLeft;
        }

        public GeoPoint bottomRight() {
            return this.bottomRight;
        }
    }
}

