/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.metrics.avg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.codelibs.elasticsearch.common.lease.Releasables;
import org.codelibs.elasticsearch.common.util.BigArrays;
import org.codelibs.elasticsearch.common.util.DoubleArray;
import org.codelibs.elasticsearch.common.util.LongArray;
import org.codelibs.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.codelibs.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.codelibs.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class AvgAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource.Numeric valuesSource;
    LongArray counts;
    DoubleArray sums;
    DocValueFormat format;

    public AvgAggregator(String name, ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.format = formatter;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                AvgAggregator.this.counts = bigArrays.grow(AvgAggregator.this.counts, bucket + 1L);
                AvgAggregator.this.sums = bigArrays.grow(AvgAggregator.this.sums, bucket + 1L);
                values.setDocument(doc);
                int valueCount = values.count();
                AvgAggregator.this.counts.increment(bucket, valueCount);
                double sum = 0.0;
                for (int i = 0; i < valueCount; ++i) {
                    sum += values.valueAt(i);
                }
                AvgAggregator.this.sums.increment(bucket, sum);
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.sums);
    }
}

