/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ObjectParser;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.search.aggregations.AggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.TermsAggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.codelibs.elasticsearch.search.aggregations.support.ValueType;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class TermsAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource, TermsAggregationBuilder> {
    public static final String NAME = "terms";
    private static final InternalAggregation.Type TYPE = new InternalAggregation.Type("terms");
    public static final ParseField EXECUTION_HINT_FIELD_NAME = new ParseField("execution_hint", new String[0]);
    public static final ParseField SHARD_SIZE_FIELD_NAME = new ParseField("shard_size", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD_NAME = new ParseField("min_doc_count", new String[0]);
    public static final ParseField SHARD_MIN_DOC_COUNT_FIELD_NAME = new ParseField("shard_min_doc_count", new String[0]);
    public static final ParseField REQUIRED_SIZE_FIELD_NAME = new ParseField("size", new String[0]);
    static final TermsAggregator.BucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = new TermsAggregator.BucketCountThresholds(1L, 0L, 10, -1);
    public static final ParseField SHOW_TERM_DOC_COUNT_ERROR = new ParseField("show_term_doc_count_error", new String[0]);
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    private static final ObjectParser<TermsAggregationBuilder, QueryParseContext> PARSER = new ObjectParser("terms");
    private Terms.Order order = Terms.Order.compound(Terms.Order.count(false), Terms.Order.term(true));
    private IncludeExclude includeExclude = null;
    private String executionHint = null;
    private Aggregator.SubAggCollectionMode collectMode = null;
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);
    private boolean showTermDocCountError = false;

    public static AggregationBuilder parse(String aggregationName, QueryParseContext context) throws IOException {
        return PARSER.parse(context.parser(), new TermsAggregationBuilder(aggregationName, null), context);
    }

    public TermsAggregationBuilder(String name, ValueType valueType) {
        super(name, TYPE, ValuesSourceType.ANY, valueType);
    }

    public TermsAggregationBuilder(StreamInput in) throws IOException {
        super(in, TYPE, ValuesSourceType.ANY);
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(in);
        this.collectMode = in.readOptionalWriteable(Aggregator.SubAggCollectionMode::readFromStream);
        this.executionHint = in.readOptionalString();
        this.includeExclude = in.readOptionalWriteable(IncludeExclude::new);
        this.order = InternalOrder.Streams.readOrder(in);
        this.showTermDocCountError = in.readBoolean();
    }

    @Override
    protected boolean serializeTargetValueType() {
        return true;
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        this.bucketCountThresholds.writeTo(out);
        out.writeOptionalWriteable(this.collectMode);
        out.writeOptionalString(this.executionHint);
        out.writeOptionalWriteable(this.includeExclude);
        InternalOrder.Streams.writeOrder(this.order, out);
        out.writeBoolean(this.showTermDocCountError);
    }

    public TermsAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public TermsAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public TermsAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public TermsAggregationBuilder shardMinDocCount(long shardMinDocCount) {
        if (shardMinDocCount < 0L) {
            throw new IllegalArgumentException("[shardMinDocCount] must be greater than or equal to 0. Found [" + shardMinDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    public TermsAggregationBuilder order(Terms.Order order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order;
        return this;
    }

    public TermsAggregationBuilder order(List<Terms.Order> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(Terms.Order.compound(orders));
        return this;
    }

    public Terms.Order order() {
        return this.order;
    }

    public TermsAggregationBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    public String executionHint() {
        return this.executionHint;
    }

    public TermsAggregationBuilder collectMode(Aggregator.SubAggCollectionMode collectMode) {
        if (collectMode == null) {
            throw new IllegalArgumentException("[collectMode] must not be null: [" + this.name + "]");
        }
        this.collectMode = collectMode;
        return this;
    }

    public Aggregator.SubAggCollectionMode collectMode() {
        return this.collectMode;
    }

    public TermsAggregationBuilder includeExclude(IncludeExclude includeExclude) {
        this.includeExclude = includeExclude;
        return this;
    }

    public IncludeExclude includeExclude() {
        return this.includeExclude;
    }

    public boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    public TermsAggregationBuilder showTermDocCountError(boolean showTermDocCountError) {
        this.showTermDocCountError = showTermDocCountError;
        return this;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new TermsAggregatorFactory(this.name, this.type, config, this.order, this.includeExclude, this.executionHint, this.collectMode, this.bucketCountThresholds, this.showTermDocCountError, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.bucketCountThresholds.toXContent(builder, params);
        builder.field(SHOW_TERM_DOC_COUNT_ERROR.getPreferredName(), this.showTermDocCountError);
        if (this.executionHint != null) {
            builder.field(EXECUTION_HINT_FIELD_NAME.getPreferredName(), this.executionHint);
        }
        builder.field(ORDER_FIELD.getPreferredName());
        this.order.toXContent(builder, params);
        if (this.collectMode != null) {
            builder.field(Aggregator.SubAggCollectionMode.KEY.getPreferredName(), this.collectMode.parseField().getPreferredName());
        }
        if (this.includeExclude != null) {
            this.includeExclude.toXContent(builder, params);
        }
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.bucketCountThresholds, this.collectMode, this.executionHint, this.includeExclude, this.order, this.showTermDocCountError);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        TermsAggregationBuilder other = (TermsAggregationBuilder)obj;
        return Objects.equals(this.bucketCountThresholds, other.bucketCountThresholds) && Objects.equals(this.collectMode, other.collectMode) && Objects.equals(this.executionHint, other.executionHint) && Objects.equals(this.includeExclude, other.includeExclude) && Objects.equals(this.order, other.order) && Objects.equals(this.showTermDocCountError, other.showTermDocCountError);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    private static Terms.Order parseOrderParam(XContentParser parser, QueryParseContext context) throws IOException {
        XContentParser.Token token;
        Terms.Order orderParam = null;
        String orderKey = null;
        boolean orderAsc = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                orderKey = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                String dir = parser.text();
                if ("asc".equalsIgnoreCase(dir)) {
                    orderAsc = true;
                    continue;
                }
                if ("desc".equalsIgnoreCase(dir)) {
                    orderAsc = false;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown terms order direction [" + dir + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " for [order]", new Object[0]);
        }
        if (orderKey == null) {
            throw new ParsingException(parser.getTokenLocation(), "Must specify at least one field for [order]", new Object[0]);
        }
        orderParam = TermsAggregationBuilder.resolveOrder(orderKey, orderAsc);
        return orderParam;
    }

    static Terms.Order resolveOrder(String key, boolean asc) {
        if ("_term".equals(key)) {
            return Terms.Order.term(asc);
        }
        if ("_count".equals(key)) {
            return Terms.Order.count(asc);
        }
        return Terms.Order.aggregation(key, asc);
    }

    static {
        ValuesSourceParserHelper.declareAnyFields(PARSER, true, true);
        PARSER.declareBoolean(TermsAggregationBuilder::showTermDocCountError, SHOW_TERM_DOC_COUNT_ERROR);
        PARSER.declareInt(TermsAggregationBuilder::shardSize, SHARD_SIZE_FIELD_NAME);
        PARSER.declareLong(TermsAggregationBuilder::minDocCount, MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareLong(TermsAggregationBuilder::shardMinDocCount, SHARD_MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareInt(TermsAggregationBuilder::size, REQUIRED_SIZE_FIELD_NAME);
        PARSER.declareString(TermsAggregationBuilder::executionHint, EXECUTION_HINT_FIELD_NAME);
        PARSER.declareField(TermsAggregationBuilder::collectMode, (p, c) -> Aggregator.SubAggCollectionMode.parse(p.text()), Aggregator.SubAggCollectionMode.KEY, ObjectParser.ValueType.STRING);
        PARSER.declareObjectArray(TermsAggregationBuilder::order, TermsAggregationBuilder::parseOrderParam, ORDER_FIELD);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge(v, b.includeExclude())), IncludeExclude::parseInclude, IncludeExclude.INCLUDE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge(b.includeExclude(), v)), IncludeExclude::parseExclude, IncludeExclude.EXCLUDE_FIELD, ObjectParser.ValueType.STRING_ARRAY);
    }
}

