/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.codelibs.elasticsearch.common.lease.Releasables;
import org.codelibs.elasticsearch.common.util.BytesRefHash;
import org.codelibs.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class StringTermsAggregator
extends AbstractStringTermsAggregator {
    private final ValuesSource valuesSource;
    protected final BytesRefHash bucketOrds;
    private final IncludeExclude.StringFilter includeExclude;

    public StringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, Terms.Order order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.StringFilter includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
        this.bucketOrds = new BytesRefHash(1L, context.bigArrays());
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){
            final BytesRefBuilder previous;
            {
                super(sub2, values2);
                this.previous = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                values.setDocument(doc);
                int valuesCount = values.count();
                this.previous.clear();
                for (int i = 0; i < valuesCount; ++i) {
                    BytesRef bytes = values.valueAt(i);
                    if (StringTermsAggregator.this.includeExclude != null && !StringTermsAggregator.this.includeExclude.accept(bytes) || this.previous.get().equals((Object)bytes)) continue;
                    long bucketOrdinal = StringTermsAggregator.this.bucketOrds.add(bytes);
                    if (bucketOrdinal < 0L) {
                        bucketOrdinal = -1L - bucketOrdinal;
                        StringTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                    } else {
                        StringTermsAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                    }
                    this.previous.copyBytes(bytes);
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

