/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.codelibs.elasticsearch.common.lease.Releasables;
import org.codelibs.elasticsearch.common.util.LongHash;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class LongTermsAggregator
extends TermsAggregator {
    protected final ValuesSource.Numeric valuesSource;
    protected final LongHash bucketOrds;
    private boolean showTermDocCountError;
    private IncludeExclude.LongFilter longFilter;

    public LongTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, IncludeExclude.LongFilter longFilter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, bucketCountThresholds, order, format, subAggCollectMode, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.showTermDocCountError = showTermDocCountError;
        this.longFilter = longFilter;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    protected SortedNumericDocValues getValues(ValuesSource.Numeric valuesSource, LeafReaderContext ctx) throws IOException {
        return valuesSource.longValues(ctx);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDocValues values = this.getValues(this.valuesSource, ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrdinal) throws IOException {
                assert (owningBucketOrdinal == 0L);
                values.setDocument(doc);
                int valuesCount = values.count();
                long previous = Long.MAX_VALUE;
                for (int i = 0; i < valuesCount; ++i) {
                    long val = values.valueAt(i);
                    if (previous == val && i != 0) continue;
                    if (LongTermsAggregator.this.longFilter == null || LongTermsAggregator.this.longFilter.accept(val)) {
                        long bucketOrdinal = LongTermsAggregator.this.bucketOrds.add(val);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            LongTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                        } else {
                            LongTermsAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                        }
                    }
                    previous = val;
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new LongTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

