/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.AggregationExecutionException;
import org.codelibs.elasticsearch.search.aggregations.Aggregations;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalTerms<A extends InternalTerms<A, B>, B extends Bucket<B>>
extends InternalMultiBucketAggregation<A, B>
implements Terms,
ToXContent {
    protected static final String DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME = "doc_count_error_upper_bound";
    protected static final String SUM_OF_OTHER_DOC_COUNTS = "sum_other_doc_count";
    protected final Terms.Order order;
    protected final int requiredSize;
    protected final long minDocCount;

    protected InternalTerms(String name, Terms.Order order, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.order = order;
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
    }

    protected InternalTerms(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readOrder(in);
        this.requiredSize = InternalTerms.readSize(in);
        this.minDocCount = in.readVLong();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeOrder(this.order, out);
        InternalTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public final List<Terms.Bucket> getBuckets() {
        return Collections.unmodifiableList(this.getBucketsInternal());
    }

    protected abstract List<B> getBucketsInternal();

    public abstract B getBucketByKey(String var1);

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        HashMap<Object, ArrayList<Bucket>> buckets = new HashMap<Object, ArrayList<Bucket>>();
        long sumDocCountError = 0L;
        long otherDocCount = 0L;
        Object referenceTerms = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (referenceTerms == null && !aggregation.getClass().equals(UnmappedTerms.class)) {
                referenceTerms = terms;
            }
            if (referenceTerms != null && !referenceTerms.getClass().equals(terms.getClass()) && !terms.getClass().equals(UnmappedTerms.class)) {
                throw new AggregationExecutionException("Merging/Reducing the aggregations failed when computing the aggregation [" + ((InternalAggregation)referenceTerms).getName() + "] because the field you gave in the aggregation query existed as two different " + "types in two different indices");
            }
            otherDocCount += terms.getSumOfOtherDocCounts();
            long thisAggDocCountError = terms.getBucketsInternal().size() < this.getShardSize() || InternalOrder.isTermOrder(this.order) ? 0L : (InternalOrder.isCountDesc(this.order) ? ((Bucket)terms.getBucketsInternal().get((int)(terms.getBucketsInternal().size() - 1))).docCount : -1L);
            if (sumDocCountError != -1L) {
                sumDocCountError = thisAggDocCountError == -1L ? -1L : (sumDocCountError += thisAggDocCountError);
            }
            this.setDocCountError(thisAggDocCountError);
            for (Bucket bucket : terms.getBucketsInternal()) {
                bucket.docCountError = thisAggDocCountError;
                ArrayList<Bucket> bucketList = (ArrayList<Bucket>)buckets.get(bucket.getKey());
                if (bucketList == null) {
                    bucketList = new ArrayList<Bucket>();
                    buckets.put(bucket.getKey(), bucketList);
                }
                bucketList.add(bucket);
            }
        }
        int size = Math.min(this.requiredSize, buckets.size());
        BucketPriorityQueue<Terms.Bucket> ordered = new BucketPriorityQueue<Terms.Bucket>(size, this.order.comparator(null));
        for (List sameTermBuckets : buckets.values()) {
            Bucket removed;
            Object b = ((Bucket)sameTermBuckets.get(0)).reduce(sameTermBuckets, reduceContext);
            if (((Bucket)b).docCountError != -1L) {
                ((Bucket)b).docCountError = sumDocCountError == -1L ? -1L : sumDocCountError - ((Bucket)b).docCountError;
            }
            if (((Bucket)b).docCount < this.minDocCount || (removed = (Bucket)ordered.insertWithOverflow(b)) == null) continue;
            otherDocCount += removed.getDocCount();
        }
        Bucket[] list = this.createBucketsArray(ordered.size());
        for (int i = ordered.size() - 1; i >= 0; --i) {
            list[i] = (Bucket)ordered.pop();
        }
        long docCountError = sumDocCountError == -1L ? -1L : (aggregations.size() == 1 ? 0L : sumDocCountError);
        return this.create(this.name, Arrays.asList(list), docCountError, otherDocCount);
    }

    protected abstract void setDocCountError(long var1);

    protected abstract int getShardSize();

    protected abstract A create(String var1, List<B> var2, long var3, long var5);

    protected abstract B[] createBucketsArray(int var1);

    public static abstract class Bucket<B extends Bucket<B>>
    extends Terms.Bucket {
        long bucketOrd;
        protected long docCount;
        protected long docCountError;
        protected InternalAggregations aggregations;
        protected final boolean showDocCountError;
        protected final DocValueFormat format;

        protected Bucket(long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat formatter) {
            this.showDocCountError = showDocCountError;
            this.format = formatter;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.docCountError = docCountError;
        }

        protected Bucket(StreamInput in, DocValueFormat formatter, boolean showDocCountError) throws IOException {
            this.showDocCountError = showDocCountError;
            this.format = formatter;
            this.docCount = in.readVLong();
            this.docCountError = -1L;
            if (showDocCountError) {
                this.docCountError = in.readLong();
            }
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public final void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.getDocCount());
            if (this.showDocCountError) {
                out.writeLong(this.docCountError);
            }
            this.aggregations.writeTo(out);
            this.writeTermTo(out);
        }

        protected abstract void writeTermTo(StreamOutput var1) throws IOException;

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public long getDocCountError() {
            if (!this.showDocCountError) {
                throw new IllegalStateException("show_terms_doc_count_error is false");
            }
            return this.docCountError;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        abstract B newBucket(long var1, InternalAggregations var3, long var4);

        public B reduce(List<B> buckets, InternalAggregation.ReduceContext context) {
            long docCount = 0L;
            long docCountError = 0L;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                if (docCountError != -1L) {
                    docCountError = bucket.docCountError == -1L ? -1L : (docCountError += bucket.docCountError);
                }
                aggregationsList.add(bucket.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
            return this.newBucket(docCount, aggs, docCountError);
        }

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, DocValueFormat var2, boolean var3) throws IOException;
        }
    }
}

