/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class DoubleTerms
extends InternalMappedTerms<DoubleTerms, Bucket> {
    public static final String NAME = "dterms";

    public DoubleTerms(String name, Terms.Order order, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError) {
        super(name, order, requiredSize, minDocCount, pipelineAggregators, metaData, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    public DoubleTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public DoubleTerms create(List<Bucket> buckets) {
        return new DoubleTerms(this.name, this.order, this.requiredSize, this.minDocCount, this.pipelineAggregators(), (Map<String, Object>)this.metaData, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.format);
    }

    @Override
    protected DoubleTerms create(String name, List<Bucket> buckets, long docCountError, long otherDocCount) {
        return new DoubleTerms(name, this.order, this.requiredSize, this.minDocCount, this.pipelineAggregators(), this.getMetaData(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count_error_upper_bound", this.docCountError);
        builder.field("sum_other_doc_count", this.otherDocCount);
        builder.startArray("buckets");
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        private final double term;

        public Bucket(double term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.term = term;
        }

        public Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.term = in.readDouble();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeDouble(this.term);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.term);
        }

        @Override
        public Object getKey() {
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return Double.compare(this.term, ((Number)other.getKey()).doubleValue());
        }

        @Override
        Bucket newBucket(long docCount, InternalAggregations aggs, long docCountError) {
            return new Bucket(this.term, docCount, aggs, this.showDocCountError, docCountError, this.format);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("key", this.term);
            if (this.format != DocValueFormat.RAW) {
                builder.field("key_as_string", this.format.format(this.term));
            }
            builder.field("doc_count", this.getDocCount());
            if (this.showDocCountError) {
                builder.field("doc_count_error_upper_bound", this.getDocCountError());
            }
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

