/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.lease.Releasable;
import org.codelibs.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.query.QueryBuilder;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.AggregationExecutionException;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.GlobalOrdinalsSignificantTermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.SignificantLongTermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.SignificantStringTermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class SignificantTermsAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource, SignificantTermsAggregatorFactory>
implements Releasable {
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private String indexedFieldName;
    private MappedFieldType fieldType;
    private FilterableTermsEnum termsEnum;
    private final int supersetNumDocs;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;

    public SignificantTermsAggregatorFactory(String name, InternalAggregation.Type type, ValuesSourceConfig<ValuesSource> config, IncludeExclude includeExclude, String executionHint, QueryBuilder filterBuilder, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, type, config, context, parent, subFactoriesBuilder, metaData);
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public long getSupersetNumDocs() {
        return this.supersetNumDocs;
    }

    private long getBackgroundFrequency(String value) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public long getBackgroundFrequency(BytesRef termBytes) throws IOException {
        String value = this.config.format().format(termBytes);
        return this.getBackgroundFrequency(value);
    }

    public long getBackgroundFrequency(long termNum) throws IOException {
        String value = this.config.format().format(termNum);
        return this.getBackgroundFrequency(value);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        final UnmappedSignificantTerms aggregation = new UnmappedSignificantTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), pipelineAggregators, metaData);
        return new NonCollectingAggregator(this.name, this.context, parent, pipelineAggregators, metaData){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return SignificantTermsAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize(), this.context.numberOfShards()));
        }
        if (valuesSource instanceof ValuesSource.Bytes) {
            ExecutionMode execution = null;
            if (this.executionHint != null) {
                execution = ExecutionMode.fromString(this.executionHint);
            }
            if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                execution = ExecutionMode.MAP;
            }
            if (execution == null) {
                execution = Aggregator.descendsFromBucketAggregator(parent) ? ExecutionMode.GLOBAL_ORDINALS_HASH : ExecutionMode.GLOBAL_ORDINALS;
            }
            assert (execution != null);
            DocValueFormat format = this.config.format();
            if (this.includeExclude != null && this.includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude " + "settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
            }
            return execution.create(this.name, this.factories, valuesSource, format, bucketCountThresholds, this.includeExclude, this.context, parent, this.significanceHeuristic, this, pipelineAggregators, metaData);
        }
        if (this.includeExclude != null && this.includeExclude.isRegexBased()) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude " + "settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
        }
        if (valuesSource instanceof ValuesSource.Numeric) {
            if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                throw new UnsupportedOperationException("No support for examining floating point numerics");
            }
            IncludeExclude.LongFilter longFilter = null;
            if (this.includeExclude != null) {
                longFilter = this.includeExclude.convertToLongFilter(this.config.format());
            }
            return new SignificantLongTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), bucketCountThresholds, this.context, parent, this.significanceHeuristic, this, longFilter, pipelineAggregators, metaData);
        }
        throw new AggregationExecutionException("significant_terms aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    @Override
    public void close() {
        try {
            if (this.termsEnum instanceof Releasable) {
                ((Releasable)((Object)this.termsEnum)).close();
            }
        }
        finally {
            this.termsEnum = null;
        }
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggregatorFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new SignificantStringTermsAggregator(name, factories, valuesSource, format, bucketCountThresholds, filter, aggregationContext, parent, significanceHeuristic, termsAggregatorFactory, pipelineAggregators, metaData);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggregatorFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.OrdinalsFilter filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format);
                return new GlobalOrdinalsSignificantTermsAggregator(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, format, bucketCountThresholds, filter, aggregationContext, parent, significanceHeuristic, termsAggregatorFactory, pipelineAggregators, metaData);
            }
        }
        ,
        GLOBAL_ORDINALS_HASH(new ParseField("global_ordinals_hash", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggregatorFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.OrdinalsFilter filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format);
                return new GlobalOrdinalsSignificantTermsAggregator.WithHash(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, format, bucketCountThresholds, filter, aggregationContext, parent, significanceHeuristic, termsAggregatorFactory, pipelineAggregators, metaData);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            for (ExecutionMode mode : ExecutionMode.values()) {
                if (!mode.parseField.match(value)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of " + ExecutionMode.values());
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, DocValueFormat var4, TermsAggregator.BucketCountThresholds var5, IncludeExclude var6, SearchContext var7, Aggregator var8, SignificanceHeuristic var9, SignificantTermsAggregatorFactory var10, List<PipelineAggregator> var11, Map<String, Object> var12) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

