/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.InternalMappedSignificantTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class SignificantLongTerms
extends InternalMappedSignificantTerms<SignificantLongTerms, Bucket> {
    public static final String NAME = "siglterms";

    public SignificantLongTerms(String name, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, DocValueFormat format, long subsetSize, long supersetSize, SignificanceHeuristic significanceHeuristic, List<Bucket> buckets) {
        super(name, requiredSize, minDocCount, pipelineAggregators, metaData, format, subsetSize, supersetSize, significanceHeuristic, buckets);
    }

    public SignificantLongTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public SignificantLongTerms create(List<Bucket> buckets) {
        return new SignificantLongTerms(this.name, this.requiredSize, this.minDocCount, this.pipelineAggregators(), (Map<String, Object>)this.metaData, this.format, this.subsetSize, this.supersetSize, this.significanceHeuristic, buckets);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.subsetDf, prototype.subsetSize, prototype.supersetDf, prototype.supersetSize, prototype.term, aggregations, prototype.format);
    }

    @Override
    protected SignificantLongTerms create(long subsetSize, long supersetSize, List<Bucket> buckets) {
        return new SignificantLongTerms(this.getName(), this.requiredSize, this.minDocCount, this.pipelineAggregators(), this.getMetaData(), this.format, subsetSize, supersetSize, this.significanceHeuristic, buckets);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count", this.subsetSize);
        builder.startArray("buckets");
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    static class Bucket
    extends InternalSignificantTerms.Bucket<Bucket> {
        long term;

        public Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, long term, InternalAggregations aggregations, DocValueFormat format) {
            super(subsetDf, subsetSize, supersetDf, supersetSize, aggregations, format);
            this.term = term;
        }

        public Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, long term, InternalAggregations aggregations, double score) {
            this(subsetDf, subsetSize, supersetDf, supersetSize, term, aggregations, null);
            this.score = score;
        }

        public Bucket(StreamInput in, long subsetSize, long supersetSize, DocValueFormat format) throws IOException {
            super(in, subsetSize, supersetSize, format);
            this.subsetDf = in.readVLong();
            this.supersetDf = in.readVLong();
            this.term = in.readLong();
            this.score = in.readDouble();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.subsetDf);
            out.writeVLong(this.supersetDf);
            out.writeLong(this.term);
            out.writeDouble(this.getSignificanceScore());
            this.aggregations.writeTo(out);
        }

        @Override
        public Object getKey() {
            return this.term;
        }

        @Override
        int compareTerm(SignificantTerms.Bucket other) {
            return Long.compare(this.term, ((Number)other.getKey()).longValue());
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.term);
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        Bucket newBucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            return new Bucket(subsetDf, subsetSize, supersetDf, supersetSize, this.term, aggregations, this.format);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("key", this.term);
            if (this.format != DocValueFormat.RAW) {
                builder.field("key_as_string", this.format.format(this.term));
            }
            builder.field("doc_count", this.getDocCount());
            builder.field("score", this.score);
            builder.field("bg_count", this.supersetDf);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

