/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.codelibs.elasticsearch.common.lease.Releasables;
import org.codelibs.elasticsearch.common.util.LongHash;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class GlobalOrdinalsSignificantTermsAggregator
extends GlobalOrdinalsStringTermsAggregator {
    protected long numCollectedDocs;
    protected final SignificantTermsAggregatorFactory termsAggFactory;
    private final SignificanceHeuristic significanceHeuristic;

    public GlobalOrdinalsSignificantTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.OrdinalsFilter includeExclude, SearchContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, valuesSource, null, format, bucketCountThresholds, includeExclude, context, parent, Aggregator.SubAggCollectionMode.DEPTH_FIRST, false, pipelineAggregators, metaData);
        this.significanceHeuristic = significanceHeuristic;
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(super.getLeafCollector(ctx, sub), null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                super.collect(doc, bucket);
                ++GlobalOrdinalsSignificantTermsAggregator.this.numCollectedDocs;
            }
        };
    }

    @Override
    public SignificantStringTerms buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        if (this.globalOrds == null) {
            return this.buildEmptyAggregation();
        }
        int size = this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(this.globalOrds.getValueCount(), (long)this.bucketCountThresholds.getShardSize()) : (int)Math.min(this.maxBucketOrd(), (long)this.bucketCountThresholds.getShardSize());
        long supersetSize = this.termsAggFactory.getSupersetNumDocs();
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantStringTerms.Bucket spare = null;
        for (long globalTermOrd = 0L; globalTermOrd < this.globalOrds.getValueCount(); ++globalTermOrd) {
            int bucketDocCount;
            if (this.includeExclude != null && !this.acceptedGlobalOrdinals.get(globalTermOrd)) continue;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            int n = bucketDocCount = bucketOrd < 0L ? 0 : this.bucketDocCount(bucketOrd);
            if (this.bucketCountThresholds.getMinDocCount() > 0L && bucketDocCount == 0 || (long)bucketDocCount < this.bucketCountThresholds.getShardMinDocCount()) continue;
            if (spare == null) {
                spare = new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, 0L, 0L, null, this.format);
            }
            spare.bucketOrd = bucketOrd;
            GlobalOrdinalsSignificantTermsAggregator.copy(this.globalOrds.lookupOrd(globalTermOrd), spare.termBytes);
            spare.subsetDf = bucketDocCount;
            spare.subsetSize = subsetSize;
            spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.termBytes);
            spare.supersetSize = supersetSize;
            spare.updateScore(this.significanceHeuristic);
            spare = (SignificantStringTerms.Bucket)ordered.insertWithOverflow(spare);
        }
        SignificantStringTerms.Bucket[] list = new SignificantStringTerms.Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            SignificantStringTerms.Bucket bucket = (SignificantStringTerms.Bucket)ordered.pop();
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i] = bucket;
        }
        return new SignificantStringTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, subsetSize, supersetSize, this.significanceHeuristic, Arrays.asList(list));
    }

    @Override
    public SignificantStringTerms buildEmptyAggregation() {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected void doClose() {
        Releasables.close(this.termsAggFactory);
    }

    public static class WithHash
    extends GlobalOrdinalsSignificantTermsAggregator {
        private final LongHash bucketOrds;

        public WithHash(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.OrdinalsFilter includeExclude, SearchContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, factories, valuesSource, format, bucketCountThresholds, includeExclude, context, parent, significanceHeuristic, termsAggFactory, pipelineAggregators, metaData);
            this.bucketOrds = new LongHash(1L, context.bigArrays());
        }

        @Override
        public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
            return new LeafBucketCollectorBase(super.getLeafCollector(ctx, sub), null){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    assert (bucket == 0L);
                    ++numCollectedDocs;
                    globalOrds.setDocument(doc);
                    int numOrds = globalOrds.cardinality();
                    for (int i = 0; i < numOrds; ++i) {
                        long globalOrd = globalOrds.ordAt(i);
                        long bucketOrd = bucketOrds.add(globalOrd);
                        if (bucketOrd < 0L) {
                            bucketOrd = -1L - bucketOrd;
                            this.collectExistingBucket(sub, doc, bucketOrd);
                            continue;
                        }
                        this.collectBucket(sub, doc, bucketOrd);
                    }
                }
            };
        }

        @Override
        protected long getBucketOrd(long termOrd) {
            return this.bucketOrds.find(termOrd);
        }

        @Override
        protected void doClose() {
            Releasables.close(this.termsAggFactory, this.bucketOrds);
        }
    }
}

