/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class UnmappedSampler
extends InternalSampler {
    public static final String NAME = "unmapped_sampler";

    public UnmappedSampler(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, 0L, InternalAggregations.EMPTY, pipelineAggregators, metaData);
    }

    public UnmappedSampler(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        for (InternalAggregation agg : aggregations) {
            if (agg instanceof UnmappedSampler) continue;
            return agg.reduce(aggregations, reduceContext);
        }
        return this;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count", 0);
        return builder;
    }
}

