/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.range.date;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.codelibs.elasticsearch.search.aggregations.bucket.range.date.DateRangeAggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValueType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class InternalDateRange
extends InternalRange<Bucket, InternalDateRange> {
    public static final Factory FACTORY = new Factory();

    InternalDateRange(String name, List<Bucket> ranges, DocValueFormat formatter, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, ranges, formatter, keyed, pipelineAggregators, metaData);
    }

    public InternalDateRange(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "date_range";
    }

    @Override
    public InternalRange.Factory<Bucket, InternalDateRange> getFactory() {
        return FACTORY;
    }

    public static class Factory
    extends InternalRange.Factory<Bucket, InternalDateRange> {
        @Override
        public InternalAggregation.Type type() {
            return DateRangeAggregationBuilder.TYPE;
        }

        @Override
        public ValueType getValueType() {
            return ValueType.DATE;
        }

        @Override
        public InternalDateRange create(String name, List<Bucket> ranges, DocValueFormat formatter, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
            return new InternalDateRange(name, ranges, formatter, keyed, pipelineAggregators, metaData);
        }

        @Override
        public InternalDateRange create(List<Bucket> ranges, InternalDateRange prototype) {
            return new InternalDateRange(prototype.name, ranges, prototype.format, prototype.keyed, prototype.pipelineAggregators(), (Map<String, Object>)prototype.metaData);
        }

        @Override
        public Bucket createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, DocValueFormat formatter) {
            return new Bucket(key, from, to, docCount, aggregations, keyed, formatter);
        }

        @Override
        public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
            return new Bucket(prototype.getKey(), (double)prototype.internalGetFrom(), (double)prototype.internalGetTo(), prototype.getDocCount(), aggregations, prototype.getKeyed(), prototype.getFormat());
        }
    }

    public static class Bucket
    extends InternalRange.Bucket {
        public Bucket(boolean keyed, DocValueFormat formatter) {
            super(keyed, formatter);
        }

        public Bucket(String key, double from, double to, long docCount, List<InternalAggregation> aggregations, boolean keyed, DocValueFormat formatter) {
            super(key, from, to, docCount, new InternalAggregations(aggregations), keyed, formatter);
        }

        public Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, DocValueFormat formatter) {
            super(key, from, to, docCount, aggregations, keyed, formatter);
        }

        @Override
        public Object getFrom() {
            return Double.isInfinite(this.from) ? null : new DateTime(((Number)this.from).longValue(), DateTimeZone.UTC);
        }

        @Override
        public Object getTo() {
            return Double.isInfinite(this.to) ? null : new DateTime(((Number)this.to).longValue(), DateTimeZone.UTC);
        }

        private Double internalGetFrom() {
            return this.from;
        }

        private Double internalGetTo() {
            return this.to;
        }

        protected InternalRange.Factory<Bucket, ?> getFactory() {
            return FACTORY;
        }

        boolean keyed() {
            return this.keyed;
        }

        DocValueFormat format() {
            return this.format;
        }
    }
}

