/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParseFieldMatcher;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.codelibs.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class RangeAggregator
extends BucketsAggregator {
    public static final ParseField RANGES_FIELD = new ParseField("ranges", new String[0]);
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    final Range[] ranges;
    final boolean keyed;
    final InternalRange.Factory rangeFactory;
    final double[] maxTo;

    public RangeAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, InternalRange.Factory rangeFactory, Range[] ranges, boolean keyed, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        assert (valuesSource != null);
        this.valuesSource = valuesSource;
        this.format = format;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.ranges = ranges;
        this.maxTo = new double[this.ranges.length];
        this.maxTo[0] = this.ranges[0].to;
        for (int i = 1; i < this.ranges.length; ++i) {
            this.maxTo[i] = Math.max(this.ranges[i].to, this.maxTo[i - 1]);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                values.setDocument(doc);
                int valuesCount = values.count();
                int lo = 0;
                for (int i = 0; i < valuesCount; ++i) {
                    double value = values.valueAt(i);
                    lo = this.collect(doc, value, bucket, lo);
                }
            }

            private int collect(int doc, double value, long owningBucketOrdinal, int lowBound) throws IOException {
                int lo = lowBound;
                int hi = RangeAggregator.this.ranges.length - 1;
                int mid = lo + hi >>> 1;
                while (lo <= hi) {
                    if (value < RangeAggregator.this.ranges[mid].from) {
                        hi = mid - 1;
                    } else {
                        if (!(value >= RangeAggregator.this.maxTo[mid])) break;
                        lo = mid + 1;
                    }
                    mid = lo + hi >>> 1;
                }
                if (lo > hi) {
                    return lo;
                }
                int startLo = lo;
                int startHi = mid;
                while (startLo <= startHi) {
                    int startMid = startLo + startHi >>> 1;
                    if (value >= RangeAggregator.this.maxTo[startMid]) {
                        startLo = startMid + 1;
                        continue;
                    }
                    startHi = startMid - 1;
                }
                int endLo = mid;
                int endHi = hi;
                while (endLo <= endHi) {
                    int endMid = endLo + endHi >>> 1;
                    if (value < RangeAggregator.this.ranges[endMid].from) {
                        endHi = endMid - 1;
                        continue;
                    }
                    endLo = endMid + 1;
                }
                assert (startLo == lowBound || value >= RangeAggregator.this.maxTo[startLo - 1]);
                assert (endHi == RangeAggregator.this.ranges.length - 1 || value < RangeAggregator.this.ranges[endHi + 1].from);
                for (int i = startLo; i <= endHi; ++i) {
                    if (!RangeAggregator.this.ranges[i].matches(value)) continue;
                    RangeAggregator.this.collectBucket(sub, doc, RangeAggregator.this.subBucketOrdinal(owningBucketOrdinal, i));
                }
                return endHi + 1;
            }
        };
    }

    private long subBucketOrdinal(long owningBucketOrdinal, int rangeOrd) {
        return owningBucketOrdinal * (long)this.ranges.length + (long)rangeOrd;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        ArrayList buckets = new ArrayList(this.ranges.length);
        for (int i = 0; i < this.ranges.length; ++i) {
            Range range = this.ranges[i];
            long bucketOrd = this.subBucketOrdinal(owningBucketOrdinal, i);
            Object bucket = this.rangeFactory.createBucket(range.key, range.from, range.to, this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd), this.keyed, this.format);
            buckets.add(bucket);
        }
        return this.rangeFactory.create(this.name, buckets, this.format, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList buckets = new ArrayList(this.ranges.length);
        for (Range range : this.ranges) {
            Object bucket = this.rangeFactory.createBucket(range.key, range.from, range.to, 0L, subAggs, this.keyed, this.format);
            buckets.add(bucket);
        }
        return this.rangeFactory.create(this.name, buckets, this.format, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    public static class Unmapped<R extends Range>
    extends NonCollectingAggregator {
        private final R[] ranges;
        private final boolean keyed;
        private final InternalRange.Factory factory;
        private final DocValueFormat format;

        public Unmapped(String name, R[] ranges, boolean keyed, DocValueFormat format, SearchContext context, Aggregator parent, InternalRange.Factory factory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, context, parent, pipelineAggregators, metaData);
            this.ranges = ranges;
            this.keyed = keyed;
            this.format = format;
            this.factory = factory;
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            InternalAggregations subAggs = this.buildEmptySubAggregations();
            ArrayList buckets = new ArrayList(this.ranges.length);
            for (R range : this.ranges) {
                buckets.add(this.factory.createBucket(((Range)range).key, ((Range)range).from, ((Range)range).to, 0L, subAggs, this.keyed, this.format));
            }
            return this.factory.create(this.name, buckets, this.format, this.keyed, this.pipelineAggregators(), this.metaData());
        }
    }

    public static class Range
    implements Writeable,
    ToXContent {
        public static final ParseField KEY_FIELD = new ParseField("key", new String[0]);
        public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
        public static final ParseField TO_FIELD = new ParseField("to", new String[0]);
        protected final String key;
        protected final double from;
        protected final String fromAsStr;
        protected final double to;
        protected final String toAsStr;

        public Range(String key, Double from, Double to) {
            this(key, from, null, to, null);
        }

        public Range(String key, String from, String to) {
            this(key, null, from, null, to);
        }

        public Range(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.fromAsStr = in.readOptionalString();
            this.toAsStr = in.readOptionalString();
            this.from = in.readDouble();
            this.to = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeOptionalString(this.fromAsStr);
            out.writeOptionalString(this.toAsStr);
            out.writeDouble(this.from);
            out.writeDouble(this.to);
        }

        protected Range(String key, Double from, String fromAsStr, Double to, String toAsStr) {
            this.key = key;
            this.from = from == null ? Double.NEGATIVE_INFINITY : from;
            this.fromAsStr = fromAsStr;
            this.to = to == null ? Double.POSITIVE_INFINITY : to;
            this.toAsStr = toAsStr;
        }

        boolean matches(double value) {
            return value >= this.from && value < this.to;
        }

        public String toString() {
            return "[" + this.from + " to " + this.to + ")";
        }

        public Range process(DocValueFormat parser, SearchContext context) {
            assert (parser != null);
            Double from = this.from;
            Double to = this.to;
            if (this.fromAsStr != null) {
                from = parser.parseDouble(this.fromAsStr, false, context.getQueryShardContext()::nowInMillis);
            }
            if (this.toAsStr != null) {
                to = parser.parseDouble(this.toAsStr, false, context.getQueryShardContext()::nowInMillis);
            }
            return new Range(this.key, from, this.fromAsStr, to, this.toAsStr);
        }

        public static Range fromXContent(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
            XContentParser.Token token;
            String currentFieldName = null;
            double from = Double.NEGATIVE_INFINITY;
            String fromAsStr = null;
            double to = Double.POSITIVE_INFINITY;
            String toAsStr = null;
            String key = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (FROM_FIELD.match(currentFieldName)) {
                        from = parser.doubleValue();
                        continue;
                    }
                    if (!TO_FIELD.match(currentFieldName)) continue;
                    to = parser.doubleValue();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_STRING) continue;
                if (FROM_FIELD.match(currentFieldName)) {
                    fromAsStr = parser.text();
                    continue;
                }
                if (TO_FIELD.match(currentFieldName)) {
                    toAsStr = parser.text();
                    continue;
                }
                if (!KEY_FIELD.match(currentFieldName)) continue;
                key = parser.text();
            }
            return new Range(key, from, fromAsStr, to, toAsStr);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.key != null) {
                builder.field(KEY_FIELD.getPreferredName(), this.key);
            }
            if (Double.isFinite(this.from)) {
                builder.field(FROM_FIELD.getPreferredName(), this.from);
            }
            if (Double.isFinite(this.to)) {
                builder.field(TO_FIELD.getPreferredName(), this.to);
            }
            if (this.fromAsStr != null) {
                builder.field(FROM_FIELD.getPreferredName(), this.fromAsStr);
            }
            if (this.toAsStr != null) {
                builder.field(TO_FIELD.getPreferredName(), this.toAsStr);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.from, this.fromAsStr, this.to, this.toAsStr);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Range other = (Range)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.from, other.from) && Objects.equals(this.fromAsStr, other.fromAsStr) && Objects.equals(this.to, other.to) && Objects.equals(this.toAsStr, other.toAsStr);
        }
    }
}

