/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.Objects;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregator;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class ReverseNestedAggregationBuilder
extends AbstractAggregationBuilder<ReverseNestedAggregationBuilder> {
    public static final String NAME = "reverse_nested";
    private static final InternalAggregation.Type TYPE = new InternalAggregation.Type("reverse_nested");
    private String path;

    public ReverseNestedAggregationBuilder(String name) {
        super(name, TYPE);
    }

    public ReverseNestedAggregationBuilder(StreamInput in) throws IOException {
        super(in, TYPE);
        this.path = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.path);
    }

    public ReverseNestedAggregationBuilder path(String path) {
        if (path == null) {
            throw new IllegalArgumentException("[path] must not be null: [" + this.name + "]");
        }
        this.path = path;
        return this;
    }

    public String path() {
        return this.path;
    }

    @Override
    protected AggregatorFactory<?> doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.path != null) {
            builder.field(ReverseNestedAggregator.PATH_FIELD.getPreferredName(), this.path);
        }
        builder.endObject();
        return builder;
    }

    public static ReverseNestedAggregationBuilder parse(String aggregationName, QueryParseContext context) throws IOException {
        XContentParser.Token token;
        String path = null;
        String currentFieldName = null;
        XContentParser parser = context.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("path".equals(currentFieldName)) {
                    path = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", new Object[0]);
        }
        ReverseNestedAggregationBuilder factory = new ReverseNestedAggregationBuilder(aggregationName);
        if (path != null) {
            factory.path(path);
        }
        return factory;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.path);
    }

    @Override
    protected boolean doEquals(Object obj) {
        ReverseNestedAggregationBuilder other = (ReverseNestedAggregationBuilder)obj;
        return Objects.equals(this.path, other.path);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

