/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.codelibs.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class NestedAggregator
extends SingleBucketAggregator {
    static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    private final BitSetProducer parentFilter;
    private final Query childFilter;

    public NestedAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parentAggregator, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parentAggregator, pipelineAggregators, metaData);
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)ctx);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Weight weight = searcher.createNormalizedWeight(this.childFilter, false);
        Scorer childDocsScorer = weight.scorer(ctx);
        final BitSet parentDocs = this.parentFilter.getBitSet(ctx);
        final DocIdSetIterator childDocs = childDocsScorer != null ? childDocsScorer.iterator() : null;
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int parentDoc, long bucket) throws IOException {
                if (parentDoc == 0 || parentDocs == null || childDocs == null) {
                    return;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int childDocId = childDocs.docID();
                if (childDocId <= prevParentDoc) {
                    childDocId = childDocs.advance(prevParentDoc + 1);
                }
                while (childDocId < parentDoc) {
                    NestedAggregator.this.collectBucket(sub, childDocId, bucket);
                    childDocId = childDocs.nextDoc();
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalNested(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalNested(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }
}

