/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.codelibs.elasticsearch.common.lucene.Lucene;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.codelibs.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class FilterAggregator
extends SingleBucketAggregator {
    private final Weight filter;

    public FilterAggregator(String name, Weight filter, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.filter = filter;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final Bits bits = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.filter.scorer(ctx));
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bits.get(doc)) {
                    FilterAggregator.this.collectBucket(sub, doc, bucket);
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalFilter(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalFilter(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }
}

