/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.Objects;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.query.MatchAllQueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class FilterAggregationBuilder
extends AbstractAggregationBuilder<FilterAggregationBuilder> {
    public static final String NAME = "filter";
    private static final InternalAggregation.Type TYPE = new InternalAggregation.Type("filter");
    private final QueryBuilder filter;

    public FilterAggregationBuilder(String name, QueryBuilder filter) {
        super(name, TYPE);
        if (filter == null) {
            throw new IllegalArgumentException("[filter] must not be null: [" + name + "]");
        }
        this.filter = filter;
    }

    public FilterAggregationBuilder(StreamInput in) throws IOException {
        super(in, TYPE);
        this.filter = in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.filter);
    }

    @Override
    protected AggregatorFactory<?> doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.filter != null) {
            this.filter.toXContent(builder, params);
        }
        return builder;
    }

    public static FilterAggregationBuilder parse(String aggregationName, QueryParseContext context) throws IOException {
        QueryBuilder filter = context.parseInnerQueryBuilder().orElse(new MatchAllQueryBuilder());
        return new FilterAggregationBuilder(aggregationName, filter);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.filter);
    }

    @Override
    protected boolean doEquals(Object obj) {
        FilterAggregationBuilder other = (FilterAggregationBuilder)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

