/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.children;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.lease.Releasables;
import org.codelibs.elasticsearch.common.lucene.Lucene;
import org.codelibs.elasticsearch.common.util.LongArray;
import org.codelibs.elasticsearch.common.util.LongObjectPagedHashMap;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.codelibs.elasticsearch.search.aggregations.bucket.children.InternalChildren;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class ParentToChildrenAggregator
extends SingleBucketAggregator {
    static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private final String parentType;
    private final Weight parentFilter;
    private final ValuesSource.Bytes.ParentChild valuesSource;
    private final LongArray parentOrdToBuckets;
    private final LongObjectPagedHashMap<long[]> parentOrdToOtherBuckets;

    public ParentToChildrenAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, String parentType, Query childFilter, Query parentFilter, ValuesSource.Bytes.ParentChild valuesSource, long maxOrd, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalChildren(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(this.parentType, ctx);
        assert (globalOrdinals != null);
        Scorer parentScorer = this.parentFilter.scorer(ctx);
        final Bits parentDocs = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), parentScorer);
        return new LeafBucketCollector(){

            @Override
            public void collect(int docId, long bucket) throws IOException {
                long globalOrdinal;
                if (parentDocs.get(docId) && (globalOrdinal = (long)globalOrdinals.getOrd(docId)) != -1L) {
                    if (ParentToChildrenAggregator.this.parentOrdToBuckets.get(globalOrdinal) == -1L) {
                        ParentToChildrenAggregator.this.parentOrdToBuckets.set(globalOrdinal, bucket);
                    } else {
                        long[] bucketOrds = (long[])ParentToChildrenAggregator.this.parentOrdToOtherBuckets.get(globalOrdinal);
                        if (bucketOrds != null) {
                            bucketOrds = Arrays.copyOf(bucketOrds, bucketOrds.length + 1);
                            bucketOrds[bucketOrds.length - 1] = bucket;
                            ParentToChildrenAggregator.this.parentOrdToOtherBuckets.put(globalOrdinal, bucketOrds);
                        } else {
                            ParentToChildrenAggregator.this.parentOrdToOtherBuckets.put(globalOrdinal, new long[]{bucket});
                        }
                    }
                }
            }
        };
    }

    @Override
    protected void doPostCollection() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doClose() {
        Releasables.close(this.parentOrdToBuckets, this.parentOrdToOtherBuckets);
    }
}

