/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket.children;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.bucket.children.ChildrenAggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.bucket.children.ParentToChildrenAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValueType;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class ChildrenAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Bytes.ParentChild, ChildrenAggregationBuilder> {
    public static final String NAME = "children";
    private static final InternalAggregation.Type TYPE = new InternalAggregation.Type("children");
    private String parentType;
    private final String childType;
    private Query parentFilter;
    private Query childFilter;

    public ChildrenAggregationBuilder(String name, String childType) {
        super(name, TYPE, ValuesSourceType.BYTES, ValueType.STRING);
        if (childType == null) {
            throw new IllegalArgumentException("[childType] must not be null: [" + name + "]");
        }
        this.childType = childType;
    }

    public ChildrenAggregationBuilder(StreamInput in) throws IOException {
        super(in, TYPE, ValuesSourceType.BYTES, ValueType.STRING);
        this.childType = in.readString();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.childType);
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Bytes.ParentChild, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Bytes.ParentChild> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ChildrenAggregatorFactory(this.name, this.type, config, this.parentType, this.childFilter, this.parentFilter, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected ValuesSourceConfig<ValuesSource.Bytes.ParentChild> resolveConfig(SearchContext context) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ParentToChildrenAggregator.TYPE_FIELD.getPreferredName(), this.childType);
        return builder;
    }

    public static ChildrenAggregationBuilder parse(String aggregationName, QueryParseContext context) throws IOException {
        XContentParser.Token token;
        String childType = null;
        String currentFieldName = null;
        XContentParser parser = context.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("type".equals(currentFieldName)) {
                    childType = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", new Object[0]);
        }
        if (childType == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [child_type] field for children aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new ChildrenAggregationBuilder(aggregationName, childType);
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.childType);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        ChildrenAggregationBuilder other = (ChildrenAggregationBuilder)obj;
        return Objects.equals(this.childType, other.childType);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

