/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.util.BigArrays;
import org.codelibs.elasticsearch.common.util.IntArray;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorBase;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public abstract class BucketsAggregator
extends AggregatorBase {
    private final BigArrays bigArrays;
    private IntArray docCounts;

    public BucketsAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.bigArrays = context.bigArrays();
        this.docCounts = this.bigArrays.newIntArray(1L, true);
    }

    public final long maxBucketOrd() {
        return this.docCounts.size();
    }

    public final void grow(long maxBucketOrd) {
        this.docCounts = this.bigArrays.grow(this.docCounts, maxBucketOrd);
    }

    public final void collectBucket(LeafBucketCollector subCollector, int doc, long bucketOrd) throws IOException {
        this.grow(bucketOrd + 1L);
        this.collectExistingBucket(subCollector, doc, bucketOrd);
    }

    public final void collectExistingBucket(LeafBucketCollector subCollector, int doc, long bucketOrd) throws IOException {
        this.docCounts.increment(bucketOrd, 1);
        subCollector.collect(doc, bucketOrd);
    }

    public IntArray getDocCounts() {
        return this.docCounts;
    }

    public final void incrementBucketDocCount(long bucketOrd, int inc) {
        this.docCounts = this.bigArrays.grow(this.docCounts, bucketOrd + 1L);
        this.docCounts.increment(bucketOrd, inc);
    }

    public final int bucketDocCount(long bucketOrd) {
        if (bucketOrd >= this.docCounts.size()) {
            return 0;
        }
        return this.docCounts.get(bucketOrd);
    }

    protected final InternalAggregations bucketAggregations(long bucket) throws IOException {
        InternalAggregation[] aggregations = new InternalAggregation[this.subAggregators.length];
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = this.subAggregators[i].buildAggregation(bucket);
        }
        return new InternalAggregations(Arrays.asList(aggregations));
    }

    protected final InternalAggregations bucketEmptyAggregations() {
        InternalAggregation[] aggregations = new InternalAggregation[this.subAggregators.length];
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = this.subAggregators[i].buildEmptyAggregation();
        }
        return new InternalAggregations(Arrays.asList(aggregations));
    }

    @Override
    public final void close() {
        try (IntArray releasable = this.docCounts;){
            super.close();
        }
    }
}

