/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.packed.PackedLongValues;
import org.codelibs.elasticsearch.common.util.LongHash;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.BucketCollector;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public class BestBucketsDeferringCollector
extends DeferringBucketCollector {
    final List<Entry> entries = new ArrayList<Entry>();
    BucketCollector collector;
    final SearchContext searchContext;
    LeafReaderContext context;
    PackedLongValues.Builder docDeltas;
    PackedLongValues.Builder buckets;
    long maxBucket = -1L;
    boolean finished = false;
    LongHash selectedBuckets;

    public BestBucketsDeferringCollector(SearchContext context) {
        this.searchContext = context;
    }

    public boolean needsScores() {
        if (this.collector == null) {
            throw new IllegalStateException();
        }
        return this.collector.needsScores();
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.collector = BucketCollector.wrap(deferredCollectors);
    }

    private void finishLeaf() {
        if (this.context != null) {
            this.entries.add(new Entry(this.context, this.docDeltas.build(), this.buckets.build()));
        }
        this.context = null;
        this.docDeltas = null;
        this.buckets = null;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        this.finishLeaf();
        this.context = ctx;
        this.docDeltas = PackedLongValues.packedBuilder((float)0.25f);
        this.buckets = PackedLongValues.packedBuilder((float)0.25f);
        return new LeafBucketCollector(){
            int lastDoc = 0;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                BestBucketsDeferringCollector.this.docDeltas.add((long)(doc - this.lastDoc));
                BestBucketsDeferringCollector.this.buckets.add(bucket);
                this.lastDoc = doc;
                BestBucketsDeferringCollector.this.maxBucket = Math.max(BestBucketsDeferringCollector.this.maxBucket, bucket);
            }
        };
    }

    @Override
    public void preCollection() throws IOException {
        this.collector.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.finishLeaf();
        this.finished = true;
    }

    @Override
    public void prepareSelectedBuckets(long ... selectedBuckets) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public Aggregator wrap(final Aggregator in) {
        return new DeferringBucketCollector.WrappedAggregator(in){

            @Override
            public InternalAggregation buildAggregation(long bucket) throws IOException {
                if (BestBucketsDeferringCollector.this.selectedBuckets == null) {
                    throw new IllegalStateException("Collection has not been replayed yet.");
                }
                long rebasedBucket = BestBucketsDeferringCollector.this.selectedBuckets.find(bucket);
                if (rebasedBucket == -1L) {
                    throw new IllegalStateException("Cannot build for a bucket which has not been collected");
                }
                return in.buildAggregation(rebasedBucket);
            }
        };
    }

    private static class Entry {
        public Entry(LeafReaderContext context, PackedLongValues docDeltas, PackedLongValues buckets) {
        }
    }
}

