/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.BucketCollector;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregations;
import org.codelibs.elasticsearch.search.aggregations.LeafBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.codelibs.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public abstract class AggregatorBase
extends Aggregator {
    public static final int DEFAULT_WEIGHT = 5120;
    protected final String name;
    protected final Aggregator parent;
    protected final SearchContext context;
    private final Map<String, Object> metaData;
    protected final Aggregator[] subAggregators;
    protected BucketCollector collectableSubAggregators;
    private Map<String, Aggregator> subAggregatorbyName;
    private DeferringBucketCollector recordingWrapper;
    private final List<PipelineAggregator> pipelineAggregators;

    protected AggregatorBase(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public boolean needsScores() {
        for (Aggregator agg : this.subAggregators) {
            if (!agg.needsScores()) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> metaData() {
        return this.metaData;
    }

    public List<PipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    protected abstract LeafBucketCollector getLeafCollector(LeafReaderContext var1, LeafBucketCollector var2) throws IOException;

    @Override
    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
        return this.getLeafCollector(ctx, sub);
    }

    protected void doPreCollection() throws IOException {
    }

    @Override
    public final void preCollection() throws IOException {
        ArrayList<BucketCollector> collectors = new ArrayList<BucketCollector>();
        ArrayList<BucketCollector> deferredCollectors = new ArrayList<BucketCollector>();
        for (int i = 0; i < this.subAggregators.length; ++i) {
            if (this.shouldDefer(this.subAggregators[i])) {
                if (this.recordingWrapper == null) {
                    this.recordingWrapper = this.getDeferringCollector();
                }
                deferredCollectors.add(this.subAggregators[i]);
                this.subAggregators[i] = this.recordingWrapper.wrap(this.subAggregators[i]);
                continue;
            }
            collectors.add(this.subAggregators[i]);
        }
        if (this.recordingWrapper != null) {
            this.recordingWrapper.setDeferredCollector(deferredCollectors);
            collectors.add(this.recordingWrapper);
        }
        this.collectableSubAggregators = BucketCollector.wrap(collectors);
        this.doPreCollection();
        this.collectableSubAggregators.preCollection();
    }

    public DeferringBucketCollector getDeferringCollector() {
        return new BestBucketsDeferringCollector(this.context());
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return false;
    }

    protected final void runDeferredCollections(long ... bucketOrds) throws IOException {
        if (this.recordingWrapper != null) {
            this.recordingWrapper.replay(bucketOrds);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Aggregator parent() {
        return this.parent;
    }

    public Aggregator[] subAggregators() {
        return this.subAggregators;
    }

    @Override
    public Aggregator subAggregator(String aggName) {
        if (this.subAggregatorbyName == null) {
            this.subAggregatorbyName = new HashMap<String, Aggregator>(this.subAggregators.length);
            for (Aggregator subAggregator : this.subAggregators) {
                this.subAggregatorbyName.put(subAggregator.name(), subAggregator);
            }
        }
        return this.subAggregatorbyName.get(aggName);
    }

    @Override
    public SearchContext context() {
        return this.context;
    }

    @Override
    public final void postCollection() throws IOException {
        this.doPostCollection();
        this.collectableSubAggregators.postCollection();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    protected void doClose() {
    }

    protected void doPostCollection() throws IOException {
    }

    protected final InternalAggregations buildEmptySubAggregations() {
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        for (Aggregator aggregator : this.subAggregators) {
            aggs.add(aggregator.buildEmptyAggregation());
        }
        return new InternalAggregations(aggs);
    }

    public String toString() {
        return this.name;
    }
}

