/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.script;

import java.io.IOException;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;

public enum ScriptType implements Writeable
{
    INLINE(0, new ParseField("inline", new String[0]), false),
    STORED(1, new ParseField("stored", "id"), false),
    FILE(2, new ParseField("file", new String[0]), true);

    private final int id;
    private final ParseField parseField;
    private final boolean defaultEnabled;

    public static ScriptType readFrom(StreamInput in) throws IOException {
        int id = in.readVInt();
        if (ScriptType.FILE.id == id) {
            return FILE;
        }
        if (ScriptType.STORED.id == id) {
            return STORED;
        }
        if (ScriptType.INLINE.id == id) {
            return INLINE;
        }
        throw new IllegalStateException("Error reading ScriptType id [" + id + "] from stream, expected one of [" + ScriptType.FILE.id + " [" + ScriptType.FILE.parseField.getPreferredName() + "], " + ScriptType.STORED.id + " [" + ScriptType.STORED.parseField.getPreferredName() + "], " + ScriptType.INLINE.id + " [" + ScriptType.INLINE.parseField.getPreferredName() + "]]");
    }

    private ScriptType(int id, ParseField parseField, boolean defaultEnabled) {
        this.id = id;
        this.parseField = parseField;
        this.defaultEnabled = defaultEnabled;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.parseField.getPreferredName();
    }

    public ParseField getParseField() {
        return this.parseField;
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    public String toString() {
        return this.getName();
    }
}

