/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.common.settings.Setting;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.script.ScriptContext;
import org.codelibs.elasticsearch.script.ScriptContextRegistry;
import org.codelibs.elasticsearch.script.ScriptEngineRegistry;
import org.codelibs.elasticsearch.script.ScriptModes;
import org.codelibs.elasticsearch.script.ScriptType;

public class ScriptSettings {
    static final String LEGACY_DEFAULT_LANG = "groovy";
    @Deprecated
    public static final String LEGACY_SCRIPT_SETTING = "script.legacy.default_lang";
    private static final Map<ScriptType, Setting<Boolean>> SCRIPT_TYPE_SETTING_MAP;
    private final Map<ScriptContext, Setting<Boolean>> scriptContextSettingMap;
    private final List<Setting<Boolean>> scriptLanguageSettings;
    private final Setting<String> defaultLegacyScriptLanguageSetting;

    public ScriptSettings(ScriptEngineRegistry scriptEngineRegistry, ScriptContextRegistry scriptContextRegistry) {
        Map<ScriptContext, Setting<Boolean>> scriptContextSettingMap = ScriptSettings.contextSettings(scriptContextRegistry);
        this.scriptContextSettingMap = Collections.unmodifiableMap(scriptContextSettingMap);
        List<Setting<Boolean>> scriptLanguageSettings = ScriptSettings.languageSettings(SCRIPT_TYPE_SETTING_MAP, scriptContextSettingMap, scriptEngineRegistry, scriptContextRegistry);
        this.scriptLanguageSettings = Collections.unmodifiableList(scriptLanguageSettings);
        this.defaultLegacyScriptLanguageSetting = new Setting<String>(LEGACY_SCRIPT_SETTING, LEGACY_DEFAULT_LANG, setting -> {
            if (!LEGACY_DEFAULT_LANG.equals(setting) && !scriptEngineRegistry.getRegisteredLanguages().containsKey(setting)) {
                throw new IllegalArgumentException("unregistered default language [" + setting + "]");
            }
            return setting;
        }, Setting.Property.NodeScope);
    }

    private static Map<ScriptContext, Setting<Boolean>> contextSettings(ScriptContextRegistry scriptContextRegistry) {
        HashMap<ScriptContext, Setting<Boolean>> scriptContextSettingMap = new HashMap<ScriptContext, Setting<Boolean>>();
        for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
            scriptContextSettingMap.put(scriptContext, Setting.boolSetting(ScriptModes.operationKey(scriptContext), false, Setting.Property.NodeScope));
        }
        return scriptContextSettingMap;
    }

    private static List<Setting<Boolean>> languageSettings(Map<ScriptType, Setting<Boolean>> scriptTypeSettingMap, Map<ScriptContext, Setting<Boolean>> scriptContextSettingMap, ScriptEngineRegistry scriptEngineRegistry, ScriptContextRegistry scriptContextRegistry) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SCRIPT_TYPE_SETTING_MAP.values());
        settings.addAll(this.scriptContextSettingMap.values());
        settings.addAll(this.scriptLanguageSettings);
        settings.add(this.defaultLegacyScriptLanguageSetting);
        return settings;
    }

    public Iterable<Setting<Boolean>> getScriptLanguageSettings() {
        return this.scriptLanguageSettings;
    }

    public Setting<String> getDefaultLegacyScriptLanguageSetting() {
        return this.defaultLegacyScriptLanguageSetting;
    }

    public static String getLegacyDefaultLang(Settings settings) {
        return settings.get(LEGACY_SCRIPT_SETTING, LEGACY_DEFAULT_LANG);
    }

    static {
        HashMap<ScriptType, Setting<Boolean>> scriptTypeSettingMap = new HashMap<ScriptType, Setting<Boolean>>();
        for (ScriptType scriptType : ScriptType.values()) {
            scriptTypeSettingMap.put(scriptType, Setting.boolSetting(ScriptModes.sourceKey(scriptType), scriptType.isDefaultEnabled(), Setting.Property.NodeScope));
        }
        SCRIPT_TYPE_SETTING_MAP = Collections.unmodifiableMap(scriptTypeSettingMap);
    }
}

