/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.codelibs.elasticsearch.common.settings.Setting;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.script.ScriptContext;
import org.codelibs.elasticsearch.script.ScriptSettings;
import org.codelibs.elasticsearch.script.ScriptType;

public class ScriptModes {
    private static final String SCRIPT_SETTINGS_PREFIX = "script";
    private static final String ENGINE_SETTINGS_PREFIX = "script.engine";
    final Map<String, Boolean> scriptEnabled;

    ScriptModes(ScriptSettings scriptSettings, Settings settings) {
        HashMap<String, Boolean> scriptModes = new HashMap<String, Boolean>();
        for (Setting<Boolean> scriptModeSetting : scriptSettings.getScriptLanguageSettings()) {
            scriptModes.put(scriptModeSetting.getKey(), scriptModeSetting.get(settings));
        }
        this.scriptEnabled = Collections.unmodifiableMap(scriptModes);
    }

    public boolean getScriptEnabled(String lang, ScriptType scriptType, ScriptContext scriptContext) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    static String operationKey(ScriptContext scriptContext) {
        return "script." + scriptContext.getKey();
    }

    static String sourceKey(ScriptType scriptType) {
        return "script." + scriptType.getName();
    }

    static String getGlobalKey(String lang, ScriptType scriptType) {
        return "script.engine." + lang + "." + scriptType;
    }

    static String getKey(String lang, ScriptType scriptType, ScriptContext scriptContext) {
        return "script.engine." + lang + "." + scriptType + "." + scriptContext.getKey();
    }

    public String toString() {
        TreeMap<String, Boolean> scriptModesTreeMap = new TreeMap<String, Boolean>();
        scriptModesTreeMap.putAll(this.scriptEnabled);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry stringScriptModeEntry : scriptModesTreeMap.entrySet()) {
            stringBuilder.append((String)stringScriptModeEntry.getKey()).append(": ").append(stringScriptModeEntry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }
}

