/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.script;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.codelibs.elasticsearch.Version;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParseFieldMatcher;
import org.codelibs.elasticsearch.common.ParseFieldMatcherSupplier;
import org.codelibs.elasticsearch.common.bytes.BytesArray;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.xcontent.ObjectParser;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentFactory;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.common.xcontent.XContentType;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.script.ScriptType;

public final class Script
implements ToXContent,
Writeable {
    public static final Version V_5_1_0_UNRELEASED = Version.fromId(5010099);
    public static final String DEFAULT_SCRIPT_LANG = "painless";
    public static final String DEFAULT_TEMPLATE_LANG = "mustache";
    public static final ScriptType DEFAULT_SCRIPT_TYPE = ScriptType.INLINE;
    public static final String CONTENT_TYPE_OPTION = "content_type";
    public static final ParseField SCRIPT_PARSE_FIELD = new ParseField("script", new String[0]);
    public static final ParseField LANG_PARSE_FIELD = new ParseField("lang", new String[0]);
    public static final ParseField OPTIONS_PARSE_FIELD = new ParseField("options", new String[0]);
    public static final ParseField PARAMS_PARSE_FIELD = new ParseField("params", new String[0]);
    private static final ObjectParser<Builder, ParseFieldMatcherSupplier> PARSER = new ObjectParser("script", () -> new Builder());
    private final ScriptType type;
    private final String lang;
    private final String idOrCode;
    private final Map<String, String> options;
    private final Map<String, Object> params;

    public static Script parse(XContentParser parser, ParseFieldMatcher matcher) throws IOException {
        return Script.parse(parser, matcher, DEFAULT_SCRIPT_LANG);
    }

    public static Script parse(XContentParser parser, QueryParseContext context) throws IOException {
        return Script.parse(parser, context.getParseFieldMatcher(), context.getDefaultScriptLanguage());
    }

    public static Script parse(XContentParser parser, ParseFieldMatcher matcher, String defaultLang) throws IOException {
        Objects.requireNonNull(defaultLang);
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return new Script(ScriptType.INLINE, defaultLang, parser.text(), Collections.emptyMap());
        }
        return Script.PARSER.apply(parser, () -> matcher).build(defaultLang);
    }

    public Script(String idOrCode) {
        this(DEFAULT_SCRIPT_TYPE, DEFAULT_SCRIPT_LANG, idOrCode, Collections.emptyMap(), Collections.emptyMap());
    }

    public Script(ScriptType type, String lang, String idOrCode, Map<String, Object> params) {
        this(type, lang, idOrCode, Collections.emptyMap(), params);
    }

    public Script(ScriptType type, String lang, String idOrCode, Map<String, String> options, Map<String, Object> params) {
        this.idOrCode = Objects.requireNonNull(idOrCode);
        this.type = Objects.requireNonNull(type);
        this.lang = Objects.requireNonNull(lang);
        this.options = Collections.unmodifiableMap(Objects.requireNonNull(options));
        this.params = Collections.unmodifiableMap(Objects.requireNonNull(params));
        if (type != ScriptType.INLINE && !options.isEmpty()) {
            throw new IllegalArgumentException("Compiler options [" + options + "] cannot be specified at runtime for [" + type + "] scripts.");
        }
    }

    public Script(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED)) {
            this.type = ScriptType.readFrom(in);
            this.lang = in.readString();
            this.idOrCode = in.readString();
            Map<String, Object> options = in.readMap();
            this.options = options;
            this.params = in.readMap();
        } else {
            Map<String, Object> params;
            String idOrCode = in.readString();
            ScriptType type = in.readBoolean() ? ScriptType.readFrom(in) : DEFAULT_SCRIPT_TYPE;
            String lang = in.readOptionalString();
            if (lang == null) {
                lang = DEFAULT_SCRIPT_LANG;
            }
            if ((params = in.readMap()) == null) {
                params = new HashMap<String, Object>();
            }
            HashMap<String, String> options = new HashMap<String, String>();
            if (in.readBoolean()) {
                XContentType contentType = XContentType.readFrom(in);
                options.put(CONTENT_TYPE_OPTION, contentType.mediaType());
            }
            this.type = type;
            this.lang = lang;
            this.idOrCode = idOrCode;
            this.options = options;
            this.params = params;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED)) {
            this.type.writeTo(out);
            out.writeString(this.lang);
            out.writeString(this.idOrCode);
            Map<String, Object> options = this.options;
            out.writeMap(options);
            out.writeMap(this.params);
        } else {
            out.writeString(this.idOrCode);
            out.writeBoolean(true);
            this.type.writeTo(out);
            out.writeBoolean(true);
            out.writeString(this.lang);
            out.writeMap(this.params.isEmpty() ? null : this.params);
            if (this.options.containsKey(CONTENT_TYPE_OPTION)) {
                XContentType contentType = XContentType.fromMediaTypeOrFormat(this.options.get(CONTENT_TYPE_OPTION));
                out.writeBoolean(true);
                contentType.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        String contentType = this.options.get(CONTENT_TYPE_OPTION);
        if (this.type == ScriptType.INLINE && contentType != null && builder.contentType().mediaType().equals(contentType)) {
            builder.rawField(this.type.getParseField().getPreferredName(), new BytesArray(this.idOrCode));
        } else {
            builder.field(this.type.getParseField().getPreferredName(), this.idOrCode);
        }
        builder.field(LANG_PARSE_FIELD.getPreferredName(), this.lang);
        if (!this.options.isEmpty()) {
            builder.field(OPTIONS_PARSE_FIELD.getPreferredName(), this.options);
        }
        if (!this.params.isEmpty()) {
            builder.field(PARAMS_PARSE_FIELD.getPreferredName(), this.params);
        }
        builder.endObject();
        return builder;
    }

    public String getIdOrCode() {
        return this.idOrCode;
    }

    public ScriptType getType() {
        return this.type;
    }

    public String getLang() {
        return this.lang;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Script script = (Script)o;
        if (this.type != script.type) {
            return false;
        }
        if (!this.lang.equals(script.lang)) {
            return false;
        }
        if (!this.idOrCode.equals(script.idOrCode)) {
            return false;
        }
        if (!this.options.equals(script.options)) {
            return false;
        }
        return this.params.equals(script.params);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.lang.hashCode();
        result = 31 * result + this.idOrCode.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }

    public String toString() {
        return "Script{type=" + this.type + ", lang='" + this.lang + '\'' + ", idOrCode='" + this.idOrCode + '\'' + ", options=" + this.options + ", params=" + this.params + '}';
    }

    static {
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setInline(x$0), parser -> parser, ScriptType.INLINE.getParseField(), ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setStored(x$0), ScriptType.STORED.getParseField());
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setFile(x$0), ScriptType.FILE.getParseField());
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setLang(x$0), LANG_PARSE_FIELD);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setOptions(x$0), XContentParser::mapStrings, OPTIONS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setParams(x$0), XContentParser::map, PARAMS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static final class Builder {
        private ScriptType type;
        private String lang;
        private String idOrCode;
        private Map<String, String> options = new HashMap<String, String>();
        private Map<String, Object> params = Collections.emptyMap();

        private Builder() {
        }

        private void setInline(XContentParser parser) {
            try {
                if (this.type != null) {
                    this.throwOnlyOneOfType();
                }
                this.type = ScriptType.INLINE;
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = XContentFactory.contentBuilder(parser.contentType());
                    this.idOrCode = builder.copyCurrentStructure(parser).bytes().utf8ToString();
                    this.options.put(Script.CONTENT_TYPE_OPTION, parser.contentType().mediaType());
                } else {
                    this.idOrCode = parser.text();
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void setStored(String idOrCode) {
            if (this.type != null) {
                this.throwOnlyOneOfType();
            }
            this.type = ScriptType.STORED;
            this.idOrCode = idOrCode;
        }

        private void setFile(String idOrCode) {
            if (this.type != null) {
                this.throwOnlyOneOfType();
            }
            this.type = ScriptType.FILE;
            this.idOrCode = idOrCode;
        }

        private void throwOnlyOneOfType() {
            throw new IllegalArgumentException("must only use one of [" + ScriptType.INLINE.getParseField().getPreferredName() + " + , " + ScriptType.STORED.getParseField().getPreferredName() + " + , " + ScriptType.FILE.getParseField().getPreferredName() + "]" + " when specifying a script");
        }

        private void setLang(String lang) {
            this.lang = lang;
        }

        private void setOptions(Map<String, String> options) {
            this.options.putAll(options);
        }

        private void setParams(Map<String, Object> params) {
            this.params = params;
        }

        private Script build(String defaultLang) {
            if (this.type == null) {
                throw new IllegalArgumentException("must specify either code for an [" + ScriptType.INLINE.getParseField().getPreferredName() + "] script " + "or an id for a [" + ScriptType.STORED.getParseField().getPreferredName() + "] script " + "or [" + ScriptType.FILE.getParseField().getPreferredName() + "] script");
            }
            if (this.idOrCode == null) {
                throw new IllegalArgumentException("must specify an id or code for a script");
            }
            if (this.options.size() > 1 || this.options.size() == 1 && this.options.get(Script.CONTENT_TYPE_OPTION) == null) {
                throw new IllegalArgumentException("illegal compiler options [" + this.options + "] specified");
            }
            return new Script(this.type, this.lang == null ? defaultLang : this.lang, this.idOrCode, this.options, this.params);
        }
    }
}

