/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.querybuilders;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.common.Nullable;
import org.codelibs.elasticsearch.common.unit.TimeValue;
import org.codelibs.elasticsearch.common.xcontent.XContentHelper;
import org.codelibs.elasticsearch.index.query.QueryBuilder;
import org.codelibs.elasticsearch.script.Script;
import org.codelibs.elasticsearch.search.SearchExtBuilder;
import org.codelibs.elasticsearch.search.aggregations.AggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.codelibs.elasticsearch.search.builder.SearchSourceBuilder;
import org.codelibs.elasticsearch.search.fetch.StoredFieldsContext;
import org.codelibs.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.codelibs.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.codelibs.elasticsearch.search.rescore.RescoreBuilder;
import org.codelibs.elasticsearch.search.slice.SliceBuilder;
import org.codelibs.elasticsearch.search.sort.SortBuilder;
import org.codelibs.elasticsearch.search.sort.SortOrder;
import org.codelibs.elasticsearch.search.suggest.SuggestBuilder;

public class SearchDslBuilder {
    public SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();

    private SearchDslBuilder() {
    }

    public SearchDslBuilder query(Supplier<QueryBuilder> query) {
        return this.query(query.get());
    }

    public SearchDslBuilder query(QueryBuilder query) {
        this.searchSourceBuilder.query(query);
        return this;
    }

    public SearchDslBuilder postFilter(Supplier<QueryBuilder> postFilter) {
        return this.postFilter(postFilter.get());
    }

    public SearchDslBuilder postFilter(QueryBuilder postFilter) {
        this.searchSourceBuilder.postFilter(postFilter);
        return this;
    }

    public SearchDslBuilder from(int from) {
        this.searchSourceBuilder.from(from);
        return this;
    }

    public SearchDslBuilder size(int size) {
        this.searchSourceBuilder.size(size);
        return this;
    }

    public SearchDslBuilder minScore(float minScore) {
        this.searchSourceBuilder.minScore(minScore);
        return this;
    }

    public SearchDslBuilder explain(Boolean explain) {
        this.searchSourceBuilder.explain(explain);
        return this;
    }

    public SearchDslBuilder timeout(TimeValue timeout) {
        this.searchSourceBuilder.timeout(timeout);
        return this;
    }

    public SearchDslBuilder terminateAfter(int terminateAfter) {
        this.searchSourceBuilder.terminateAfter(terminateAfter);
        return this;
    }

    public SearchDslBuilder sort(String name, SortOrder order) {
        this.searchSourceBuilder.sort(name, order);
        return this;
    }

    public SearchDslBuilder sort(String name) {
        this.searchSourceBuilder.sort(name);
        return this;
    }

    public SearchDslBuilder sort(SortBuilder<?> sort) {
        this.searchSourceBuilder.sort(sort);
        return this;
    }

    public SearchDslBuilder trackScores(boolean trackScores) {
        this.searchSourceBuilder.trackScores(trackScores);
        return this;
    }

    public SearchDslBuilder searchAfter(Object[] values) {
        this.searchSourceBuilder.searchAfter(values);
        return this;
    }

    public SearchDslBuilder slice(SliceBuilder builder) {
        this.searchSourceBuilder.slice(builder);
        return this;
    }

    public SearchDslBuilder aggregation(Supplier<AggregationBuilder> aggregation) {
        return this.aggregation(aggregation.get());
    }

    public SearchDslBuilder aggregation(AggregationBuilder aggregation) {
        this.searchSourceBuilder.aggregation(aggregation);
        return this;
    }

    public SearchDslBuilder aggregation(PipelineAggregationBuilder aggregation) {
        this.searchSourceBuilder.aggregation(aggregation);
        return this;
    }

    public SearchDslBuilder highlighter(Supplier<HighlightBuilder> highlightBuilder) {
        return this.highlighter(highlightBuilder.get());
    }

    public SearchDslBuilder highlighter(HighlightBuilder highlightBuilder) {
        this.searchSourceBuilder.highlighter(highlightBuilder);
        return this;
    }

    public SearchDslBuilder suggest(Supplier<SuggestBuilder> suggestBuilder) {
        this.suggest(suggestBuilder.get());
        return this;
    }

    public SearchDslBuilder suggest(SuggestBuilder suggestBuilder) {
        this.searchSourceBuilder.suggest(suggestBuilder);
        return this;
    }

    public SearchDslBuilder addRescorer(Supplier<RescoreBuilder<?>> rescoreBuilder) {
        this.addRescorer(rescoreBuilder.get());
        return this;
    }

    public SearchDslBuilder addRescorer(RescoreBuilder<?> rescoreBuilder) {
        this.searchSourceBuilder.addRescorer(rescoreBuilder);
        return this;
    }

    public SearchDslBuilder clearRescorers() {
        this.searchSourceBuilder.clearRescorers();
        return this;
    }

    public SearchDslBuilder profile(boolean profile) {
        this.searchSourceBuilder.profile(profile);
        return this;
    }

    public SearchDslBuilder fetchSource(boolean fetch) {
        this.searchSourceBuilder.fetchSource(fetch);
        return this;
    }

    public SearchDslBuilder fetchSource(@Nullable String include, @Nullable String exclude) {
        this.searchSourceBuilder.fetchSource(include, exclude);
        return this;
    }

    public SearchDslBuilder fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        this.searchSourceBuilder.fetchSource(includes, excludes);
        return this;
    }

    public SearchDslBuilder fetchSource(@Nullable FetchSourceContext fetchSourceContext) {
        this.searchSourceBuilder.fetchSource(fetchSourceContext);
        return this;
    }

    public SearchDslBuilder storedField(String name) {
        this.searchSourceBuilder.storedField(name);
        return this;
    }

    public SearchDslBuilder storedFields(List<String> fields) {
        this.searchSourceBuilder.storedFields(fields);
        return this;
    }

    public SearchDslBuilder storedFields(StoredFieldsContext context) {
        this.searchSourceBuilder.storedFields(context);
        return this;
    }

    public SearchDslBuilder docValueField(String name) {
        this.searchSourceBuilder.docValueField(name);
        return this;
    }

    public SearchDslBuilder scriptField(String name, Script script) {
        this.searchSourceBuilder.scriptField(name, script);
        return this;
    }

    public SearchDslBuilder scriptField(String name, Script script, boolean ignoreFailure) {
        this.searchSourceBuilder.scriptField(name, script, ignoreFailure);
        return this;
    }

    public SearchDslBuilder indexBoost(String index, float indexBoost) {
        this.searchSourceBuilder.indexBoost(index, indexBoost);
        return this;
    }

    public SearchDslBuilder stats(List<String> statsGroups) {
        this.searchSourceBuilder.stats(statsGroups);
        return this;
    }

    public SearchDslBuilder ext(List<SearchExtBuilder> searchExtBuilders) {
        this.searchSourceBuilder.ext(searchExtBuilders);
        return this;
    }

    public String build() {
        try {
            return XContentHelper.convertToJson(this.searchSourceBuilder.buildAsBytes(), true);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to build source.", (Throwable)e, new Object[0]);
        }
    }

    public static SearchDslBuilder builder() {
        return new SearchDslBuilder();
    }
}

