/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.search;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.lucene.search.Queries;
import org.codelibs.elasticsearch.common.unit.Fuzziness;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.index.query.support.QueryParsers;

public class MatchQuery {
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final boolean DEFAULT_LENIENCY = false;
    public static final ZeroTermsQuery DEFAULT_ZERO_TERMS_QUERY = ZeroTermsQuery.NONE;
    protected final QueryShardContext context;
    protected String analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected Fuzziness fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = 50;
    protected boolean transpositions = true;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient = false;
    protected ZeroTermsQuery zeroTermsQuery = DEFAULT_ZERO_TERMS_QUERY;
    protected Float commonTermsCutoff = null;

    public MatchQuery(QueryShardContext context) {
        this.context = context;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setCommonTermsCutoff(Float cutoff) {
        this.commonTermsCutoff = cutoff;
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public void setTranspositions(boolean transpositions) {
        this.transpositions = transpositions;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    protected Analyzer getAnalyzer(MappedFieldType fieldType) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public Query parse(Type type, String fieldName, Object value) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    protected final Query termQuery(MappedFieldType fieldType, Object value, boolean lenient) {
        try {
            return fieldType.termQuery(value, this.context);
        }
        catch (RuntimeException e) {
            if (lenient) {
                return null;
            }
            throw e;
        }
    }

    protected Query zeroTermsQuery() {
        if (this.zeroTermsQuery == DEFAULT_ZERO_TERMS_QUERY) {
            return Queries.newMatchNoDocsQuery("Matching no documents because no terms present.");
        }
        return Queries.newMatchAllQuery();
    }

    protected Query blendTermsQuery(Term[] terms, MappedFieldType fieldType) {
        return new SynonymQuery(terms);
    }

    protected Query blendTermQuery(Term term, MappedFieldType fieldType) {
        Query query;
        if (this.fuzziness != null) {
            if (fieldType != null) {
                try {
                    Query query2 = fieldType.fuzzyQuery(term.text(), this.fuzziness, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
                    if (query2 instanceof FuzzyQuery) {
                        QueryParsers.setRewriteMethod((MultiTermQuery)((FuzzyQuery)query2), this.fuzzyRewriteMethod);
                    }
                    return query2;
                }
                catch (RuntimeException e) {
                    if (this.lenient) {
                        return new TermQuery(term);
                    }
                    throw e;
                }
            }
            int edits = this.fuzziness.asDistance(term.text());
            FuzzyQuery query3 = new FuzzyQuery(term, edits, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
            QueryParsers.setRewriteMethod((MultiTermQuery)query3, this.fuzzyRewriteMethod);
            return query3;
        }
        if (fieldType != null && (query = this.termQuery(fieldType, term.bytes(), this.lenient)) != null) {
            return query;
        }
        return new TermQuery(term);
    }

    public static enum ZeroTermsQuery implements Writeable
    {
        NONE(0),
        ALL(1);

        private final int ordinal;

        private ZeroTermsQuery(int ordinal) {
            this.ordinal = ordinal;
        }

        public static ZeroTermsQuery readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (ZeroTermsQuery zeroTermsQuery : ZeroTermsQuery.values()) {
                if (zeroTermsQuery.ordinal != ord) continue;
                return zeroTermsQuery;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }

    public static enum Type implements Writeable
    {
        BOOLEAN(0),
        PHRASE(1),
        PHRASE_PREFIX(2);

        private final int ordinal;

        private Type(int ordinal) {
            this.ordinal = ordinal;
        }

        public static Type readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (Type type : Type.values()) {
                if (type.ordinal != ord) continue;
                return type;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }
}

