/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.codelibs.elasticsearch.common.bytes.BytesReference;
import org.codelibs.elasticsearch.common.geo.GeoDistance;
import org.codelibs.elasticsearch.common.geo.GeoPoint;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.lucene.search.function.CombineFunction;
import org.codelibs.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.codelibs.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.codelibs.elasticsearch.common.unit.DistanceUnit;
import org.codelibs.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentFactory;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.codelibs.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.codelibs.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.codelibs.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.codelibs.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.codelibs.elasticsearch.index.fielddata.NumericDoubleValues;
import org.codelibs.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.index.query.functionscore.DecayFunction;
import org.codelibs.elasticsearch.index.query.functionscore.DecayFunctionParser;
import org.codelibs.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.codelibs.elasticsearch.search.MultiValueMode;

public abstract class DecayFunctionBuilder<DFB extends DecayFunctionBuilder<DFB>>
extends ScoreFunctionBuilder<DFB> {
    protected static final String ORIGIN = "origin";
    protected static final String SCALE = "scale";
    protected static final String DECAY = "decay";
    protected static final String OFFSET = "offset";
    public static double DEFAULT_DECAY = 0.5;
    public static MultiValueMode DEFAULT_MULTI_VALUE_MODE = MultiValueMode.MIN;
    private final String fieldName;
    private final BytesReference functionBytes;
    private MultiValueMode multiValueMode = DEFAULT_MULTI_VALUE_MODE;

    protected DecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset) {
        this(fieldName, origin, scale, offset, DEFAULT_DECAY);
    }

    protected DecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, double decay) {
        if (fieldName == null) {
            throw new IllegalArgumentException("decay function: field name must not be null");
        }
        if (scale == null) {
            throw new IllegalArgumentException("decay function: scale must not be null");
        }
        if (decay <= 0.0 || decay >= 1.0) {
            throw new IllegalStateException("decay function: decay must be in range 0..1!");
        }
        this.fieldName = fieldName;
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            if (origin != null) {
                builder.field(ORIGIN, origin);
            }
            builder.field(SCALE, scale);
            if (offset != null) {
                builder.field(OFFSET, offset);
            }
            builder.field(DECAY, decay);
            builder.endObject();
            this.functionBytes = builder.bytes();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to build inner function object", e);
        }
    }

    protected DecayFunctionBuilder(String fieldName, BytesReference functionBytes) {
        if (fieldName == null) {
            throw new IllegalArgumentException("decay function: field name must not be null");
        }
        if (functionBytes == null) {
            throw new IllegalArgumentException("decay function: function must not be null");
        }
        this.fieldName = fieldName;
        this.functionBytes = functionBytes;
    }

    protected DecayFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.functionBytes = in.readBytesReference();
        this.multiValueMode = MultiValueMode.readMultiValueModeFrom(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeBytesReference(this.functionBytes);
        this.multiValueMode.writeTo(out);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public BytesReference getFunctionBytes() {
        return this.functionBytes;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.rawField(this.fieldName, this.functionBytes);
        builder.field(DecayFunctionParser.MULTI_VALUE_MODE.getPreferredName(), this.multiValueMode.name());
        builder.endObject();
    }

    public DFB setMultiValueMode(MultiValueMode multiValueMode) {
        if (multiValueMode == null) {
            throw new IllegalArgumentException("decay function: multi_value_mode must not be null");
        }
        this.multiValueMode = multiValueMode;
        return (DFB)this;
    }

    public MultiValueMode getMultiValueMode() {
        return this.multiValueMode;
    }

    @Override
    protected boolean doEquals(DFB functionBuilder) {
        return Objects.equals(this.fieldName, ((DecayFunctionBuilder)functionBuilder).getFieldName()) && Objects.equals(this.functionBytes, ((DecayFunctionBuilder)functionBuilder).getFunctionBytes()) && Objects.equals(this.multiValueMode, ((DecayFunctionBuilder)functionBuilder).getMultiValueMode());
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.functionBytes, this.multiValueMode);
    }

    @Override
    protected ScoreFunction doToFunction(QueryShardContext context) throws IOException {
        AbstractDistanceScoreFunction scoreFunction;
        try (XContentParser parser = XContentFactory.xContent(this.functionBytes).createParser(NamedXContentRegistry.EMPTY, this.functionBytes);){
            scoreFunction = this.parseVariable(this.fieldName, parser, context, this.multiValueMode);
        }
        return scoreFunction;
    }

    protected abstract DecayFunction getDecayFunction();

    private AbstractDistanceScoreFunction parseVariable(String fieldName, XContentParser parser, QueryShardContext context, MultiValueMode mode) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public static abstract class AbstractDistanceScoreFunction
    extends ScoreFunction {
        private final double scale;
        protected final double offset;
        private final DecayFunction func;
        protected final MultiValueMode mode;

        public AbstractDistanceScoreFunction(double userSuppiedScale, double decay, double offset, DecayFunction func, MultiValueMode mode) {
            super(CombineFunction.MULTIPLY);
            this.mode = mode;
            if (userSuppiedScale <= 0.0) {
                throw new IllegalArgumentException("function_score : scale must be > 0.0.");
            }
            if (decay <= 0.0 || decay >= 1.0) {
                throw new IllegalArgumentException("function_score : decay must be in the range [0..1].");
            }
            this.scale = func.processScale(userSuppiedScale, decay);
            this.func = func;
            if (offset < 0.0) {
                throw new IllegalArgumentException("function_score : offset must be > 0.0");
            }
            this.offset = offset;
        }

        protected abstract NumericDoubleValues distance(LeafReaderContext var1);

        @Override
        public final LeafScoreFunction getLeafScoreFunction(final LeafReaderContext ctx) {
            final NumericDoubleValues distance = this.distance(ctx);
            return new LeafScoreFunction(){

                @Override
                public double score(int docId, float subQueryScore) {
                    return func.evaluate(distance.get(docId), scale);
                }

                @Override
                public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                    return Explanation.match((float)CombineFunction.toFloat(this.score(docId, subQueryScore.getValue())), (String)("Function for field " + this.getFieldName() + ":"), (Explanation[])new Explanation[]{func.explainFunction(this.getDistanceString(ctx, docId), distance.get(docId), scale)});
                }
            };
        }

        protected abstract String getDistanceString(LeafReaderContext var1, int var2);

        protected abstract String getFieldName();

        @Override
        protected boolean doEquals(ScoreFunction other) {
            AbstractDistanceScoreFunction distanceScoreFunction = (AbstractDistanceScoreFunction)other;
            return Objects.equals(this.scale, distanceScoreFunction.scale) && Objects.equals(this.offset, distanceScoreFunction.offset) && Objects.equals(this.mode, distanceScoreFunction.mode) && Objects.equals(this.func, distanceScoreFunction.func) && Objects.equals(this.getFieldName(), distanceScoreFunction.getFieldName());
        }

        @Override
        protected int doHashCode() {
            return Objects.hash(this.scale, this.offset, this.mode, this.func, this.getFieldName());
        }
    }

    static class NumericFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final IndexNumericFieldData fieldData;
        private final double origin;

        public NumericFieldDataScoreFunction(double origin, double scale, double decay, double offset, DecayFunction func, IndexNumericFieldData fieldData, MultiValueMode mode) {
            super(scale, decay, offset, func, mode);
            this.fieldData = fieldData;
            this.origin = origin;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected NumericDoubleValues distance(LeafReaderContext context) {
            final SortedNumericDoubleValues doubleValues = ((AtomicNumericFieldData)this.fieldData.load(context)).getDoubleValues();
            return this.mode.select(new MultiValueMode.UnsortedNumericDoubleValues(){

                @Override
                public int count() {
                    return doubleValues.count();
                }

                @Override
                public void setDocument(int docId) {
                    doubleValues.setDocument(docId);
                }

                @Override
                public double valueAt(int index) {
                    return Math.max(0.0, Math.abs(doubleValues.valueAt(index) - origin) - offset);
                }
            }, 0.0);
        }

        @Override
        protected String getDistanceString(LeafReaderContext ctx, int docId) {
            StringBuilder values = new StringBuilder(this.mode.name());
            values.append("[");
            SortedNumericDoubleValues doubleValues = ((AtomicNumericFieldData)this.fieldData.load(ctx)).getDoubleValues();
            doubleValues.setDocument(docId);
            int num = doubleValues.count();
            if (num > 0) {
                for (int i = 0; i < num; ++i) {
                    double value = doubleValues.valueAt(i);
                    values.append("Math.max(Math.abs(");
                    values.append(value).append("(=doc value) - ");
                    values.append(this.origin).append("(=origin))) - ");
                    values.append(this.offset).append("(=offset), 0)");
                    if (i == num - 1) continue;
                    values.append(", ");
                }
            } else {
                values.append("0.0");
            }
            values.append("]");
            return values.toString();
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldName();
        }

        @Override
        protected boolean doEquals(ScoreFunction other) {
            NumericFieldDataScoreFunction numericFieldDataScoreFunction = (NumericFieldDataScoreFunction)other;
            if (!super.doEquals(other)) {
                return false;
            }
            return Objects.equals(this.origin, numericFieldDataScoreFunction.origin);
        }
    }

    static class GeoFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final GeoPoint origin;
        private final IndexGeoPointFieldData fieldData;
        private static final GeoDistance distFunction = GeoDistance.DEFAULT;

        public GeoFieldDataScoreFunction(GeoPoint origin, double scale, double decay, double offset, DecayFunction func, IndexGeoPointFieldData fieldData, MultiValueMode mode) {
            super(scale, decay, offset, func, mode);
            this.origin = origin;
            this.fieldData = fieldData;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected NumericDoubleValues distance(LeafReaderContext context) {
            final MultiGeoPointValues geoPointValues = ((AtomicGeoPointFieldData)this.fieldData.load(context)).getGeoPointValues();
            return this.mode.select(new MultiValueMode.UnsortedNumericDoubleValues(){

                @Override
                public int count() {
                    return geoPointValues.count();
                }

                @Override
                public void setDocument(int docId) {
                    geoPointValues.setDocument(docId);
                }

                @Override
                public double valueAt(int index) {
                    GeoPoint other = geoPointValues.valueAt(index);
                    return Math.max(0.0, distFunction.calculate(origin.lat(), origin.lon(), other.lat(), other.lon(), DistanceUnit.METERS) - offset);
                }
            }, 0.0);
        }

        @Override
        protected String getDistanceString(LeafReaderContext ctx, int docId) {
            StringBuilder values = new StringBuilder(this.mode.name());
            values.append(" of: [");
            MultiGeoPointValues geoPointValues = ((AtomicGeoPointFieldData)this.fieldData.load(ctx)).getGeoPointValues();
            geoPointValues.setDocument(docId);
            int num = geoPointValues.count();
            if (num > 0) {
                for (int i = 0; i < num; ++i) {
                    GeoPoint value = geoPointValues.valueAt(i);
                    values.append("Math.max(arcDistance(");
                    values.append(value).append("(=doc value),");
                    values.append(this.origin).append("(=origin)) - ").append(this.offset).append("(=offset), 0)");
                    if (i == num - 1) continue;
                    values.append(", ");
                }
            } else {
                values.append("0.0");
            }
            values.append("]");
            return values.toString();
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldName();
        }

        @Override
        protected boolean doEquals(ScoreFunction other) {
            GeoFieldDataScoreFunction geoFieldDataScoreFunction = (GeoFieldDataScoreFunction)other;
            return super.doEquals(other) && Objects.equals(this.origin, geoFieldDataScoreFunction.origin);
        }

        @Override
        protected int doHashCode() {
            return Objects.hash(super.doHashCode(), this.origin);
        }
    }
}

