/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.query;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.Strings;
import org.codelibs.elasticsearch.common.bytes.BytesReference;
import org.codelibs.elasticsearch.common.io.stream.BytesStreamOutput;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.query.AbstractQueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryRewriteContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;

public class TermsQueryBuilder
extends AbstractQueryBuilder<TermsQueryBuilder> {
    public static final String NAME = "terms";
    public static final ParseField QUERY_NAME_FIELD = new ParseField("terms", "in");
    private final String fieldName;
    private final List<?> values;
    private static final Set<Class<? extends Number>> INTEGER_TYPES = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class));
    private static final Set<Class<?>> STRING_TYPES = new HashSet<Class>(Arrays.asList(BytesRef.class, String.class));

    public TermsQueryBuilder(String fieldName, String ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : null);
    }

    public TermsQueryBuilder(String fieldName, int ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, long ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, float ... values) {
        this(fieldName, values != null ? (Iterable)IntStream.range(0, values.length).mapToObj(i -> Float.valueOf(values[i])).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, double ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Object ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Iterable<?> values) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (values == null) {
            throw new IllegalArgumentException("No value specified for terms query");
        }
        this.fieldName = fieldName;
        this.values = TermsQueryBuilder.convert(values);
    }

    public TermsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.values = (List)in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.values);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public List<Object> values() {
        return TermsQueryBuilder.convertBack(this.values);
    }

    private static List<?> convert(Iterable<?> values) {
        ArrayList list;
        if (values instanceof List) {
            list = (ArrayList)values;
        } else {
            ArrayList arrayList = new ArrayList();
            for (Object o : values) {
                arrayList.add(o);
            }
            list = arrayList;
        }
        return TermsQueryBuilder.convert(list);
    }

    static List<?> convert(List<?> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        boolean allNumbers = list.stream().allMatch(o -> o != null && INTEGER_TYPES.contains(o.getClass()));
        if (allNumbers) {
            final long[] elements = list.stream().mapToLong(o -> ((Number)o).longValue()).toArray();
            return new AbstractList<Object>(){

                @Override
                public Object get(int index) {
                    return elements[index];
                }

                @Override
                public int size() {
                    return elements.length;
                }
            };
        }
        boolean allStrings = list.stream().allMatch(o -> o != null && STRING_TYPES.contains(o.getClass()));
        if (allStrings) {
            BytesRefBuilder builder = new BytesRefBuilder();
            try (BytesStreamOutput bytesOut = new BytesStreamOutput();){
                final int[] endOffsets = new int[list.size()];
                int i = 0;
                for (Object o2 : list) {
                    BytesRef b;
                    if (o2 instanceof BytesRef) {
                        b = (BytesRef)o2;
                    } else {
                        builder.copyChars((CharSequence)o2.toString());
                        b = builder.get();
                    }
                    bytesOut.writeBytes(b.bytes, b.offset, b.length);
                    if (i == 0) {
                        endOffsets[0] = b.length;
                    } else {
                        endOffsets[i] = Math.addExact(endOffsets[i - 1], b.length);
                    }
                    ++i;
                }
                final BytesReference bytes = bytesOut.bytes();
                AbstractList<Object> abstractList = new AbstractList<Object>(){

                    @Override
                    public Object get(int i) {
                        int startOffset = i == 0 ? 0 : endOffsets[i - 1];
                        int endOffset = endOffsets[i];
                        return bytes.slice(startOffset, endOffset - startOffset).toBytesRef();
                    }

                    @Override
                    public int size() {
                        return endOffsets.length;
                    }
                };
                return abstractList;
            }
        }
        return list.stream().map(o -> o instanceof String ? new BytesRef((CharSequence)o.toString()) : o).collect(Collectors.toList());
    }

    static List<Object> convertBack(final List<?> list) {
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public Object get(int index) {
                Object o = list.get(index);
                if (o instanceof BytesRef) {
                    o = ((BytesRef)o).utf8ToString();
                }
                return o;
            }
        };
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(this.fieldName, TermsQueryBuilder.convertBack(this.values));
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<TermsQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected int doHashCode() {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected boolean doEquals(TermsQueryBuilder other) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }
}

