/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.query;

import java.io.IOException;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.AbstractQueryBuilder;
import org.codelibs.elasticsearch.index.query.BaseTermQueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;

public class TermQueryBuilder
extends BaseTermQueryBuilder<TermQueryBuilder> {
    public static final String NAME = "term";
    private static final ParseField TERM_FIELD = new ParseField("term", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);

    public TermQueryBuilder(String fieldName, String value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, int value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, long value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, float value) {
        super(fieldName, Float.valueOf(value));
    }

    public TermQueryBuilder(String fieldName, double value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, boolean value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, Object value) {
        super(fieldName, value);
    }

    public TermQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public static Optional<TermQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String queryName = null;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                TermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (TERM_FIELD.match(currentFieldName)) {
                        value = parser.objectBytes();
                        continue;
                    }
                    if (VALUE_FIELD.match(currentFieldName)) {
                        value = parser.objectBytes();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                        queryName = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[term] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (token.isValue()) {
                TermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
                fieldName = currentFieldName;
                value = parser.objectBytes();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            throw new ParsingException(parser.getTokenLocation(), "[term] query does not support array of values", new Object[0]);
        }
        TermQueryBuilder termQuery = new TermQueryBuilder(fieldName, value);
        termQuery.boost(boost);
        if (queryName != null) {
            termQuery.queryName(queryName);
        }
        return Optional.of(termQuery);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

