/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.logging.DeprecationLogger;
import org.codelibs.elasticsearch.common.logging.Loggers;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.AbstractQueryBuilder;
import org.codelibs.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryBuilders;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryRewriteContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;

@Deprecated
public class IndicesQueryBuilder
extends AbstractQueryBuilder<IndicesQueryBuilder> {
    public static final String NAME = "indices";
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField NO_MATCH_QUERY = new ParseField("no_match_query", new String[0]);
    private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(IndicesQueryBuilder.class));
    private final QueryBuilder innerQuery;
    private final String[] indices;
    private QueryBuilder noMatchQuery = IndicesQueryBuilder.defaultNoMatchQuery();

    @Deprecated
    public IndicesQueryBuilder(QueryBuilder innerQuery, String ... indices) {
        DEPRECATION_LOGGER.deprecated("{} query is deprecated. Instead search on the '_index' field", NAME);
        if (innerQuery == null) {
            throw new IllegalArgumentException("inner query cannot be null");
        }
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("list of indices cannot be null or empty");
        }
        this.innerQuery = Objects.requireNonNull(innerQuery);
        this.indices = indices;
    }

    public IndicesQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.innerQuery = in.readNamedWriteable(QueryBuilder.class);
        this.indices = in.readStringArray();
        this.noMatchQuery = in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.innerQuery);
        out.writeStringArray(this.indices);
        out.writeNamedWriteable(this.noMatchQuery);
    }

    public QueryBuilder innerQuery() {
        return this.innerQuery;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesQueryBuilder noMatchQuery(QueryBuilder noMatchQuery) {
        if (noMatchQuery == null) {
            throw new IllegalArgumentException("noMatch query cannot be null");
        }
        this.noMatchQuery = noMatchQuery;
        return this;
    }

    public IndicesQueryBuilder noMatchQuery(String type) {
        this.noMatchQuery = IndicesQueryBuilder.parseNoMatchQuery(type);
        return this;
    }

    public QueryBuilder noMatchQuery() {
        return this.noMatchQuery;
    }

    private static QueryBuilder defaultNoMatchQuery() {
        return QueryBuilders.matchAllQuery();
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.array(INDICES_FIELD.getPreferredName(), this.indices);
        builder.field(QUERY_FIELD.getPreferredName());
        this.innerQuery.toXContent(builder, params);
        builder.field(NO_MATCH_QUERY.getPreferredName());
        this.noMatchQuery.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<IndicesQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException, ParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        QueryBuilder innerQuery = null;
        ArrayList<String> indices = new ArrayList<String>();
        QueryBuilder noMatchQuery = IndicesQueryBuilder.defaultNoMatchQuery();
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    innerQuery = parseContext.parseInnerQueryBuilder().orElse(new MatchNoneQueryBuilder());
                    continue;
                }
                if (NO_MATCH_QUERY.match(currentFieldName)) {
                    noMatchQuery = parseContext.parseInnerQueryBuilder().orElse(IndicesQueryBuilder.defaultNoMatchQuery());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[indices] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (INDICES_FIELD.match(currentFieldName)) {
                    if (!indices.isEmpty()) {
                        throw new ParsingException(parser.getTokenLocation(), "[indices] indices or index already specified", new Object[0]);
                    }
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        String value = parser.textOrNull();
                        if (value == null) {
                            throw new ParsingException(parser.getTokenLocation(), "[indices] no value specified for 'indices' entry", new Object[0]);
                        }
                        indices.add(value);
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[indices] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (INDEX_FIELD.match(currentFieldName)) {
                if (!indices.isEmpty()) {
                    throw new ParsingException(parser.getTokenLocation(), "[indices] indices or index already specified", new Object[0]);
                }
                indices.add(parser.text());
                continue;
            }
            if (NO_MATCH_QUERY.match(currentFieldName)) {
                noMatchQuery = IndicesQueryBuilder.parseNoMatchQuery(parser.text());
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[indices] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (innerQuery == null) {
            throw new ParsingException(parser.getTokenLocation(), "[indices] requires 'query' element", new Object[0]);
        }
        if (indices.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "[indices] requires 'indices' or 'index' element", new Object[0]);
        }
        return Optional.of(((IndicesQueryBuilder)new IndicesQueryBuilder(innerQuery, indices.toArray(new String[indices.size()])).noMatchQuery(noMatchQuery).boost(boost)).queryName(queryName));
    }

    static QueryBuilder parseNoMatchQuery(String type) {
        if ("all".equals(type)) {
            return QueryBuilders.matchAllQuery();
        }
        if ("none".equals(type)) {
            return new MatchNoneQueryBuilder();
        }
        throw new IllegalArgumentException("query type can only be [all] or [none] but not [" + type + "]");
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public int doHashCode() {
        return Objects.hash(this.innerQuery, this.noMatchQuery, Arrays.hashCode(this.indices));
    }

    @Override
    protected boolean doEquals(IndicesQueryBuilder other) {
        return Objects.equals(this.innerQuery, other.innerQuery) && Arrays.equals(this.indices, other.indices) && Objects.equals(this.noMatchQuery, other.noMatchQuery);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder newInnnerQuery = this.innerQuery.rewrite(queryShardContext);
        QueryBuilder newNoMatchQuery = this.noMatchQuery.rewrite(queryShardContext);
        if (newInnnerQuery != this.innerQuery || newNoMatchQuery != this.noMatchQuery) {
            return new IndicesQueryBuilder(this.innerQuery, this.indices).noMatchQuery(this.noMatchQuery);
        }
        return this;
    }
}

