/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.Strings;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ObjectParser;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.query.AbstractQueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;

public class IdsQueryBuilder
extends AbstractQueryBuilder<IdsQueryBuilder> {
    public static final String NAME = "ids";
    private static final ParseField TYPE_FIELD = new ParseField("type", "types", "_type");
    private static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    private final Set<String> ids = new HashSet<String>();
    private String[] types = Strings.EMPTY_ARRAY;
    private static ObjectParser<IdsQueryBuilder, QueryParseContext> PARSER = new ObjectParser("ids", () -> new IdsQueryBuilder());

    public IdsQueryBuilder() {
    }

    @Deprecated
    public IdsQueryBuilder(String ... types) {
        this.types(types);
    }

    public IdsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.types = in.readStringArray();
        Collections.addAll(this.ids, in.readStringArray());
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.types);
        out.writeStringArray(this.ids.toArray(new String[this.ids.size()]));
    }

    public IdsQueryBuilder types(String ... types) {
        if (types == null) {
            throw new IllegalArgumentException("[ids] types cannot be null");
        }
        this.types = types;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public IdsQueryBuilder addIds(String ... ids) {
        if (ids == null) {
            throw new IllegalArgumentException("[ids] ids cannot be null");
        }
        Collections.addAll(this.ids, ids);
        return this;
    }

    public Set<String> ids() {
        return this.ids;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.array(TYPE_FIELD.getPreferredName(), this.types);
        builder.startArray(VALUES_FIELD.getPreferredName());
        for (String value : this.ids) {
            builder.value(value);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<IdsQueryBuilder> fromXContent(QueryParseContext context) {
        try {
            return Optional.of(PARSER.apply(context.parser(), context));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(context.parser().getTokenLocation(), e.getMessage(), e, new Object[0]);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.ids, Arrays.hashCode(this.types));
    }

    @Override
    protected boolean doEquals(IdsQueryBuilder other) {
        return Objects.equals(this.ids, other.ids) && Arrays.equals(this.types, other.types);
    }

    static {
        PARSER.declareStringArray(ObjectParser.fromList(String.class, IdsQueryBuilder::types), TYPE_FIELD);
        PARSER.declareStringArray(ObjectParser.fromList(String.class, IdsQueryBuilder::addIds), VALUES_FIELD);
        IdsQueryBuilder.declareStandardFields(PARSER);
    }
}

