/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ScoreMode;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.AbstractQueryBuilder;
import org.codelibs.elasticsearch.index.query.InnerHitBuilder;
import org.codelibs.elasticsearch.index.query.QueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryRewriteContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;

public class HasChildQueryBuilder
extends AbstractQueryBuilder<HasChildQueryBuilder> {
    public static final String NAME = "has_child";
    public static final int DEFAULT_MAX_CHILDREN = Integer.MAX_VALUE;
    public static final int DEFAULT_MIN_CHILDREN = 0;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField QUERY_FIELD = new ParseField("query", "filter");
    private static final ParseField TYPE_FIELD = new ParseField("type", "child_type");
    private static final ParseField MAX_CHILDREN_FIELD = new ParseField("max_children", new String[0]);
    private static final ParseField MIN_CHILDREN_FIELD = new ParseField("min_children", new String[0]);
    private static final ParseField SCORE_MODE_FIELD = new ParseField("score_mode", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final QueryBuilder query;
    private final String type;
    private final ScoreMode scoreMode;
    private InnerHitBuilder innerHitBuilder;
    private int minChildren = 0;
    private int maxChildren = Integer.MAX_VALUE;
    private boolean ignoreUnmapped = false;

    public HasChildQueryBuilder(String type, QueryBuilder query, ScoreMode scoreMode) {
        this(type, query, 0, Integer.MAX_VALUE, scoreMode, null);
    }

    private HasChildQueryBuilder(String type, QueryBuilder query, int minChildren, int maxChildren, ScoreMode scoreMode, InnerHitBuilder innerHitBuilder) {
        this.type = HasChildQueryBuilder.requireValue(type, "[has_child] requires 'type' field");
        this.query = HasChildQueryBuilder.requireValue(query, "[has_child] requires 'query' field");
        this.scoreMode = HasChildQueryBuilder.requireValue(scoreMode, "[has_child] requires 'score_mode' field");
        this.innerHitBuilder = innerHitBuilder;
        this.minChildren = minChildren;
        this.maxChildren = maxChildren;
    }

    public HasChildQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.minChildren = in.readInt();
        this.maxChildren = in.readInt();
        this.scoreMode = ScoreMode.values()[in.readVInt()];
        this.query = in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeInt(this.minChildren);
        out.writeInt(this.maxChildren);
        out.writeVInt(this.scoreMode.ordinal());
        out.writeNamedWriteable(this.query);
        out.writeOptionalWriteable(this.innerHitBuilder);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public HasChildQueryBuilder minMaxChildren(int minChildren, int maxChildren) {
        if (minChildren < 0) {
            throw new IllegalArgumentException("[has_child] requires non-negative 'min_children' field");
        }
        if (maxChildren < 0) {
            throw new IllegalArgumentException("[has_child] requires non-negative 'max_children' field");
        }
        if (maxChildren < minChildren) {
            throw new IllegalArgumentException("[has_child] 'max_children' is less than 'min_children'");
        }
        this.minChildren = minChildren;
        this.maxChildren = maxChildren;
        return this;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public HasChildQueryBuilder innerHit(InnerHitBuilder innerHit, boolean ignoreUnmapped) {
        this.innerHitBuilder = new InnerHitBuilder(Objects.requireNonNull(innerHit), this.query, this.type, ignoreUnmapped);
        return this;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public String childType() {
        return this.type;
    }

    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    public int minChildren() {
        return this.minChildren;
    }

    public int maxChildren() {
        return this.maxChildren;
    }

    public HasChildQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(SCORE_MODE_FIELD.getPreferredName(), HasChildQueryBuilder.scoreModeAsString(this.scoreMode));
        builder.field(MIN_CHILDREN_FIELD.getPreferredName(), this.minChildren);
        builder.field(MAX_CHILDREN_FIELD.getPreferredName(), this.maxChildren);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static Optional<HasChildQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        String childType = null;
        ScoreMode scoreMode = ScoreMode.None;
        int minChildren = 0;
        int maxChildren = Integer.MAX_VALUE;
        boolean ignoreUnmapped = false;
        String queryName = null;
        InnerHitBuilder innerHitBuilder = null;
        String currentFieldName = null;
        Optional<Object> iqb = Optional.empty();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    iqb = parseContext.parseInnerQueryBuilder();
                    continue;
                }
                if (INNER_HITS_FIELD.match(currentFieldName)) {
                    innerHitBuilder = InnerHitBuilder.fromXContent(parseContext);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[has_child] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (TYPE_FIELD.match(currentFieldName)) {
                childType = parser.text();
                continue;
            }
            if (SCORE_MODE_FIELD.match(currentFieldName)) {
                scoreMode = HasChildQueryBuilder.parseScoreMode(parser.text());
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (MIN_CHILDREN_FIELD.match(currentFieldName)) {
                minChildren = parser.intValue(true);
                continue;
            }
            if (MAX_CHILDREN_FIELD.match(currentFieldName)) {
                maxChildren = parser.intValue(true);
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[has_child] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!iqb.isPresent()) {
            return Optional.empty();
        }
        HasChildQueryBuilder hasChildQueryBuilder = new HasChildQueryBuilder(childType, (QueryBuilder)iqb.get(), scoreMode);
        hasChildQueryBuilder.minMaxChildren(minChildren, maxChildren);
        hasChildQueryBuilder.queryName(queryName);
        hasChildQueryBuilder.boost(boost);
        hasChildQueryBuilder.ignoreUnmapped(ignoreUnmapped);
        if (innerHitBuilder != null) {
            hasChildQueryBuilder.innerHit(innerHitBuilder, ignoreUnmapped);
        }
        return Optional.of(hasChildQueryBuilder);
    }

    public static ScoreMode parseScoreMode(String scoreModeString) {
        if ("none".equals(scoreModeString)) {
            return ScoreMode.None;
        }
        if ("min".equals(scoreModeString)) {
            return ScoreMode.Min;
        }
        if ("max".equals(scoreModeString)) {
            return ScoreMode.Max;
        }
        if ("avg".equals(scoreModeString)) {
            return ScoreMode.Avg;
        }
        if ("sum".equals(scoreModeString)) {
            return ScoreMode.Total;
        }
        throw new IllegalArgumentException("No score mode for child query [" + scoreModeString + "] found");
    }

    public static String scoreModeAsString(ScoreMode scoreMode) {
        if (scoreMode == ScoreMode.Total) {
            return "sum";
        }
        return scoreMode.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected boolean doEquals(HasChildQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.type, that.type) && Objects.equals(this.scoreMode, that.scoreMode) && Objects.equals(this.minChildren, that.minChildren) && Objects.equals(this.maxChildren, that.maxChildren) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.query, this.type, this.scoreMode, this.minChildren, this.maxChildren, this.innerHitBuilder, this.ignoreUnmapped);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryRewriteContext);
        if (rewrittenQuery != this.query) {
            InnerHitBuilder rewrittenInnerHit = InnerHitBuilder.rewrite(this.innerHitBuilder, rewrittenQuery);
            HasChildQueryBuilder hasChildQueryBuilder = new HasChildQueryBuilder(this.type, rewrittenQuery, this.minChildren, this.maxChildren, this.scoreMode, rewrittenInnerHit);
            hasChildQueryBuilder.ignoreUnmapped(this.ignoreUnmapped);
            return hasChildQueryBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitBuilder> innerHits) {
        if (this.innerHitBuilder != null) {
            this.innerHitBuilder.inlineInnerHits(innerHits);
        }
    }
}

