/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.ElasticsearchParseException;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.Strings;
import org.codelibs.elasticsearch.common.geo.GeoHashUtils;
import org.codelibs.elasticsearch.common.geo.GeoPoint;
import org.codelibs.elasticsearch.common.geo.GeoUtils;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.unit.DistanceUnit;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.AbstractQueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;

public class GeohashCellQuery {
    public static final String NAME = "geohash_cell";
    public static final boolean DEFAULT_NEIGHBORS = false;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField NEIGHBORS_FIELD = new ParseField("neighbors", new String[0]);
    private static final ParseField PRECISION_FIELD = new ParseField("precision", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);

    public static class Builder
    extends AbstractQueryBuilder<Builder> {
        private String fieldName;
        private String geohash;
        private Integer levels = null;
        private boolean neighbors = false;
        private boolean ignoreUnmapped = false;

        public Builder(String field, GeoPoint point) {
            this(field, point == null ? null : point.geohash(), false);
        }

        public Builder(String field, String geohash) {
            this(field, geohash, false);
        }

        public Builder(String field, String geohash, boolean neighbors) {
            if (Strings.isEmpty(field)) {
                throw new IllegalArgumentException("fieldName must not be null");
            }
            if (Strings.isEmpty(geohash)) {
                throw new IllegalArgumentException("geohash or point must be defined");
            }
            this.fieldName = field;
            this.geohash = geohash;
            this.neighbors = neighbors;
        }

        public Builder(StreamInput in) throws IOException {
            super(in);
            this.fieldName = in.readString();
            this.geohash = in.readString();
            this.levels = in.readOptionalVInt();
            this.neighbors = in.readBoolean();
            this.ignoreUnmapped = in.readBoolean();
        }

        @Override
        protected void doWriteTo(StreamOutput out) throws IOException {
            out.writeString(this.fieldName);
            out.writeString(this.geohash);
            out.writeOptionalVInt(this.levels);
            out.writeBoolean(this.neighbors);
            out.writeBoolean(this.ignoreUnmapped);
        }

        public Builder point(GeoPoint point) {
            this.geohash = point.getGeohash();
            return this;
        }

        public Builder point(double lat, double lon) {
            this.geohash = GeoHashUtils.stringEncode(lon, lat);
            return this;
        }

        public Builder geohash(String geohash) {
            this.geohash = geohash;
            return this;
        }

        public String geohash() {
            return this.geohash;
        }

        public Builder precision(int levels) {
            if (levels <= 0) {
                throw new IllegalArgumentException("precision must be greater than 0. Found [" + levels + "]");
            }
            this.levels = levels;
            return this;
        }

        public Integer precision() {
            return this.levels;
        }

        public Builder precision(String precision) {
            double meters = DistanceUnit.parse(precision, DistanceUnit.DEFAULT, DistanceUnit.METERS);
            return this.precision(GeoUtils.geoHashLevelsForPrecision(meters));
        }

        public Builder neighbors(boolean neighbors) {
            this.neighbors = neighbors;
            return this;
        }

        public boolean neighbors() {
            return this.neighbors;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Builder ignoreUnmapped(boolean ignoreUnmapped) {
            this.ignoreUnmapped = ignoreUnmapped;
            return this;
        }

        public boolean ignoreUnmapped() {
            return this.ignoreUnmapped;
        }

        @Override
        protected Query doToQuery(QueryShardContext context) throws IOException {
            throw new UnsupportedOperationException("querybuilders does not support this operation.");
        }

        @Override
        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(GeohashCellQuery.NAME);
            builder.field(NEIGHBORS_FIELD.getPreferredName(), this.neighbors);
            if (this.levels != null) {
                builder.field(PRECISION_FIELD.getPreferredName(), this.levels);
            }
            builder.field(this.fieldName, this.geohash);
            builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
            this.printBoostAndQueryName(builder);
            builder.endObject();
        }

        public static Optional<Builder> fromXContent(QueryParseContext parseContext) throws IOException {
            XContentParser parser = parseContext.parser();
            String fieldName = null;
            String geohash = null;
            Integer levels = null;
            Boolean neighbors = null;
            String queryName = null;
            Float boost = null;
            boolean ignoreUnmapped = false;
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse [{}] query. expected an object but found [{}] instead", new Object[]{GeohashCellQuery.NAME, token});
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String field = parser.currentName();
                    if (parseContext.isDeprecatedSetting(field)) continue;
                    if (PRECISION_FIELD.match(field)) {
                        token = parser.nextToken();
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            levels = parser.intValue();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_STRING) continue;
                        double meters = DistanceUnit.parse(parser.text(), DistanceUnit.DEFAULT, DistanceUnit.METERS);
                        levels = GeoUtils.geoHashLevelsForPrecision(meters);
                        continue;
                    }
                    if (NEIGHBORS_FIELD.match(field)) {
                        parser.nextToken();
                        neighbors = parser.booleanValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(field)) {
                        parser.nextToken();
                        queryName = parser.text();
                        continue;
                    }
                    if (IGNORE_UNMAPPED_FIELD.match(field)) {
                        parser.nextToken();
                        ignoreUnmapped = parser.booleanValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(field)) {
                        parser.nextToken();
                        boost = Float.valueOf(parser.floatValue());
                        continue;
                    }
                    if (fieldName == null) {
                        fieldName = field;
                        token = parser.nextToken();
                        if (token == XContentParser.Token.VALUE_STRING) {
                            String location = parser.text();
                            if (location.indexOf(",") > 0) {
                                geohash = GeoUtils.parseGeoPoint(parser).geohash();
                                continue;
                            }
                            geohash = location;
                            continue;
                        }
                        geohash = GeoUtils.parseGeoPoint(parser).geohash();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[geohash_cell] field name already set to [" + fieldName + "] but found [" + field + "]", new Object[0]);
                }
                throw new ElasticsearchParseException("failed to parse [{}] query. unexpected token [{}]", new Object[]{GeohashCellQuery.NAME, token});
            }
            Builder builder = new Builder(fieldName, geohash);
            if (levels != null) {
                builder.precision(levels);
            }
            if (neighbors != null) {
                builder.neighbors(neighbors);
            }
            if (queryName != null) {
                builder.queryName(queryName);
            }
            if (boost != null) {
                builder.boost(boost.floatValue());
            }
            builder.ignoreUnmapped(ignoreUnmapped);
            return Optional.of(builder);
        }

        @Override
        protected boolean doEquals(Builder other) {
            return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.geohash, other.geohash) && Objects.equals(this.levels, other.levels) && Objects.equals(this.neighbors, other.neighbors) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
        }

        @Override
        protected int doHashCode() {
            return Objects.hash(this.fieldName, this.geohash, this.levels, this.neighbors, this.ignoreUnmapped);
        }

        @Override
        public String getWriteableName() {
            return GeohashCellQuery.NAME;
        }
    }
}

